<?php namespace Visiosoft\ImportModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Import\ImportFacebookProductsEntryModel;
use Visiosoft\ImportModule\FacebookProduct\Contract\FacebookProductRepositoryInterface;
use Visiosoft\ImportModule\FacebookProduct\FacebookProductModel;
use Visiosoft\ImportModule\FacebookProduct\FacebookProductRepository;

class ImportModuleServiceProvider extends AddonServiceProvider
{
    protected $routes = [
        'admin/import' => 'Visiosoft\ImportModule\Http\Controller\Admin\ImportController@index',
        'api/admin/import/facebook_products/create' => 'Visiosoft\ImportModule\Http\Controller\Admin\FacebookProductsController@create',
    ];

    protected $bindings = [
        ImportFacebookProductsEntryModel::class => FacebookProductModel::class,
    ];

    protected $singletons = [
        FacebookProductRepositoryInterface::class => FacebookProductRepository::class,
    ];
}
