<?php namespace Visiosoft\ImportModule;

use Anomaly\FilesModule\Disk\Contract\DiskRepositoryInterface;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Stream\Command\DeleteStreamTranslations;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class ImportModuleSeeder extends Seeder
{
    private $folderRepository;
    private $diskRepository;
    private $streamRepository;

    public function __construct(
        FolderRepositoryInterface $folderRepository,
        DiskRepositoryInterface $diskRepository,
        StreamRepositoryInterface $streamRepository
    )
    {
        parent::__construct();
        $this->folderRepository = $folderRepository;
        $this->diskRepository = $diskRepository;
        $this->streamRepository = $streamRepository;
    }

    public function run()
    {
        $folders = [
            [
                'name' => 'Xml & Excel Files',
                'slug' => 'xml_and_excel_files',
                'description' => 'A folder for xml and excel files.',
                'allowed_types' => ['xml', 'xls', 'xlsx'],
            ],
            [
                'name' => 'CSV Files',
                'slug' => 'csv_files',
                'description' => 'A folder for csv files.',
                'allowed_types' => [],
            ],
        ];

        foreach ($folders as $folder) {
            // Check if folder exists
            $filesFolder = $this->folderRepository->findBySlug($folder['slug']);

            if (!$filesFolder) {
                // Delete stream if exists
                $stream = $this->streamRepository->findBySlugAndNamespace($folder['slug'], 'files');
                if ($stream) {
                    $deleteStreamTranslations = new DeleteStreamTranslations($stream);
                    $deleteStreamTranslations->handle();
                    $stream->delete();
                }

                // Get disk
                $disk = $this->diskRepository->findBySlug('local');

                $this->folderRepository->create([
                    'disk' => $disk,
                    'name' => $folder['name'],
                    'slug' => $folder['slug'],
                    'description' => $folder['description'],
                    'allowed_types' => $folder['allowed_types'],
                ]);
            }
        }
    }
}