// User select start
$("select[name=created_by]").select2({
    ajax: {
        url: '/api/profile/query-users',
        dataType: 'json',
        processResults: function (data) {
            let formattedData = [];

            Object.keys(data).forEach(function (id) {
                formattedData.push({
                    'id': id,
                    'text': data[id]
                })
            });

            return {
                results: formattedData
            }
        }
    }
});
// User select end

// Submit form start
$('form').submit(function (e) {
    e.preventDefault();

    const form = $(this);
    const url = form.attr('action');

    $.ajax({
        type: "POST",
        url: url,
        data: form.serialize(),
        success: function(data) {
            if (data.success) {
                $('input, select, textarea, button', form).prop('disabled', true)
                $('button', form).text('Added!');
            } else {
                alert(data.msg)
            }
        },
        error: function (e) {
            const errors = e.responseJSON.errors
            if (errors) {
                let errorMsg = `${e.responseJSON.message}\r\n`;
                for (const error in errors) {
                    errorMsg += `${error}:\r\n`;
                    for (let i = 0; i < errors[error].length; i++) {
                        errorMsg += `${errors[error][i]}\r\n`;
                    }
                }
                alert(errorMsg)
            } else {
                alert(e.responseJSON.message);
            }
        }
    });
})
// Submit form end

// Location select start
getCities(defaultCountry);

function getCities(country) {
    const selectsInput = $('select[name=city], select[name=district]')
    selectsInput.prop('disabled', true)

    $('select[name="district"]').html("<option value=''>" + pick_option + "</option>");

    return crudAjax(`id=${country}`, '/ajax/getCities', 'POST', () => {}, true)
        .then(function (cities) {
            $('select[name="city"]').html("<option value=''>" + pick_option + "</option>");
            $.each(cities, function (index, value) {
                $('select[name="city"]').append("<option value='" + value.id + "'>" + value.name + "</option>");
            });
            selectsInput.prop('disabled', false)
        })
}

function getDistricts(city, form = null) {
    const selectDistrictInput = $('select[name=district]', form);
    selectDistrictInput.prop('disabled', true)

    return crudAjax(`id=${city}`, '/ajax/getDistricts', 'POST', () => {}, true)
        .then(function (districts) {
            selectDistrictInput.html(`<option value=''>${pick_option}</option>`);
            $.each(districts, function (index, value) {
                selectDistrictInput.append(`<option value='${value.id}'>${value.name}</option>`);
            });
            selectDistrictInput.prop('disabled', false)
        })
}

$('select[name="city"]').on('change', function () {
    const form = $(this).closest('form');
    getDistricts($(this).val(), form);
});
// Location select end

// Cat select start
function getCats(i, cat = null, change = false, form = document) {
    $(`select[name=cat${i}]`, form).prop('disabled', true)

    $(`select[name=cat${i + 1}]`).html("<option value=''>" + pick_option + "</option>");

    $.get('/class/ajaxCategory', { level: i - 1, cat })
        .then((response) => {
            const currSelect = $(`select[name=cat${i}]`, form)
            currSelect.html(`<option value="">${pick_option}</option>`)
            for (let ii = 0; ii < response.length; ii++) {
                currSelect.append(`
                    <option value="${response[ii].id}">${response[ii].name}</option>
                `)
            }
            currSelect.prop('disabled', false)
        })
}
getCats(1);

$(`select[name=cat1]`).on('change', function () {
    changeCat(2, this.value, $(this).closest('form'))
})

function changeCat(level, id, form) {
    getCats(level, id, true, form)
}
// Cat select end
