<?php namespace Visiosoft\HurriyetemlakModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\HurriyetemlakModule\Pagination\Contract\PaginationRepositoryInterface;
use Visiosoft\HurriyetemlakModule\Pagination\PaginationRepository;
use Anomaly\Streams\Platform\Model\Hurriyetemlak\HurriyetemlakPaginationsEntryModel;
use Visiosoft\HurriyetemlakModule\Pagination\PaginationModel;
use Visiosoft\HurriyetemlakModule\Field\Contract\FieldRepositoryInterface;
use Visiosoft\HurriyetemlakModule\Field\FieldRepository;
use Anomaly\Streams\Platform\Model\Hurriyetemlak\HurriyetemlakFieldsEntryModel;
use Visiosoft\HurriyetemlakModule\Field\FieldModel;
use Illuminate\Routing\Router;

class HurriyetemlakModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/hurriyetemlak/paginations'           => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\PaginationsController@index',
        'admin/hurriyetemlak/paginations/create'    => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\PaginationsController@create',
        'admin/hurriyetemlak/paginations/edit/{id}' => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\PaginationsController@edit',
        'admin/hurriyetemlak/fields'           => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\FieldsController@index',
        'admin/hurriyetemlak/fields/create'    => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\FieldsController@create',
        'admin/hurriyetemlak/fields/edit/{id}' => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\FieldsController@edit',

        'admin/hurriyetemlak' => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\ProductController@index',

        'admin/hurriyetemlak/cron' => 'Visiosoft\HurriyetemlakModule\Http\Controller\Admin\ProductController@cron',

        'hurriyetemlak/get-ads-details' => 'Visiosoft\HurriyetemlakModule\Http\Controller\ProductController@getAdsDetails',

        'hurriyetemlak/pagination/get' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.hurriyetemlak::pagination_get',
            'uses' => 'Visiosoft\HurriyetemlakModule\Http\Controller\ProductController@index',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\HurriyetemlakModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\HurriyetemlakModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\HurriyetemlakModule\Event\ExampleEvent::class => [
        //    Visiosoft\HurriyetemlakModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\HurriyetemlakModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        HurriyetemlakPaginationsEntryModel::class => PaginationModel::class,
        HurriyetemlakFieldsEntryModel::class => FieldModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        PaginationRepositoryInterface::class => PaginationRepository::class,
        FieldRepositoryInterface::class => FieldRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
