<?php namespace Visiosoft\HurriyetemlakModule\Http\Controller;

use Anomaly\FilesModule\File\Contract\FileRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\Streams\Platform\Model\Cats\CatsCategoryEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Customfields\CustomfieldsCfvalueEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationCitiesEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationDistrictsEntryTranslationsModel;
use Anomaly\Streams\Platform\Model\Location\LocationNeighborhoodsEntryTranslationsModel;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\BotModule\Http\Controller\ScrapesController;
use Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomFieldAdv\Contract\CustomFieldAdvRepositoryInterface;
use Visiosoft\HurriyetemlakModule\Pagination\Contract\PaginationRepositoryInterface;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;
use Visiosoft\LocationModule\District\Contract\DistrictRepositoryInterface;
use Visiosoft\LocationModule\Neighborhood\Contract\NeighborhoodRepositoryInterface;
use Visiosoft\HurriyetemlakModule\Field\Contract\FieldRepositoryInterface;

class ProductController extends PublicController
{

    private $paginationRepository;
    private $userRepository;
    private $fileRepository;
    private $str;
    private $settingRepository;
    private $scrapesController;
    private $advRepository;
    private $categoryRepository;
    private $categoryEntryTranslationsModel;
    private $cityRepository;
    private $citiesEntryTranslationsModel;
    private $districtRepository;
    private $districtsEntryTranslationsModel;
    private $neighborhoodRepository;
    private $neighborhoodsEntryTranslationsModel;
    private $fieldRepository;
    private $customFieldAdvRepository;
    private $customFieldRepository;
    private $cfvalueRepository;
    private $cfvalueEntryTranslationsModel;

    public function __construct(
        PaginationRepositoryInterface $paginationRepository,
        UserRepositoryInterface $userRepository,
        FileRepositoryInterface $fileRepository,
        Str $str,
        SettingRepositoryInterface $settingRepository,
        ScrapesController $scrapesController,
        AdvRepositoryInterface $advRepository,
        CategoryRepositoryInterface $categoryRepository,
        CatsCategoryEntryTranslationsModel $categoryEntryTranslationsModel,
        CityRepositoryInterface $cityRepository,
        LocationCitiesEntryTranslationsModel $citiesEntryTranslationsModel,
        DistrictRepositoryInterface $districtRepository,
        LocationDistrictsEntryTranslationsModel $districtsEntryTranslationsModel,
        NeighborhoodRepositoryInterface $neighborhoodRepository,
        LocationNeighborhoodsEntryTranslationsModel $neighborhoodsEntryTranslationsModel,
        FieldRepositoryInterface $fieldRepository,
        CustomFieldAdvRepositoryInterface $customFieldAdvRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        CfvalueRepositoryInterface $cfvalueRepository,
        CustomfieldsCfvalueEntryTranslationsModel $cfvalueEntryTranslationsModel
    )
    {
        set_time_limit(0);
        parent::__construct();
        $this->paginationRepository = $paginationRepository;
        $this->userRepository = $userRepository;
        $this->fileRepository = $fileRepository;
        $this->str = $str;
        $this->settingRepository = $settingRepository;
        $this->scrapesController = $scrapesController;
        $this->advRepository = $advRepository;
        $this->categoryRepository = $categoryRepository;
        $this->categoryEntryTranslationsModel = $categoryEntryTranslationsModel;
        $this->cityRepository = $cityRepository;
        $this->citiesEntryTranslationsModel = $citiesEntryTranslationsModel;
        $this->districtRepository = $districtRepository;
        $this->districtsEntryTranslationsModel = $districtsEntryTranslationsModel;
        $this->neighborhoodRepository = $neighborhoodRepository;
        $this->neighborhoodsEntryTranslationsModel = $neighborhoodsEntryTranslationsModel;
        $this->fieldRepository = $fieldRepository;
        $this->customFieldAdvRepository = $customFieldAdvRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->cfvalueRepository = $cfvalueRepository;
        $this->cfvalueEntryTranslationsModel = $cfvalueEntryTranslationsModel;
    }

    function getAdsDetails()
    {
        $createdAds = 0;

        $paginationUrls = $this->paginationRepository->newQuery()->where('is_scrapped', 0)
            ->limit(setting_value('visiosoft.module.hurriyetemlak::pagination_limit_for_ads_details'))->get();

        foreach ($paginationUrls as $pageUrl) {
            $curl = curl_init();
            curl_setopt_array($curl, array(
                CURLOPT_URL => $pageUrl->url,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36",
                ),
            ));
            $response = curl_exec($curl);
            curl_close($curl);
            $response = json_decode($response);

            if (isset($response->errors)) {
                foreach ($response->errors as $error) {
                    $this->messages->error($error . 'in: ' . $pageUrl->url);
                }
                $pageUrl->update([
                    'is_scrapped' => 2
                ]);
                continue;
            }

            foreach ($response->realtyList as $ad) {
                $adId = $ad->id;
                $productName = $ad->title;
                $username = $ad->owner->name;
                $desc = $ad->title;
                $price = [$ad->price, $ad->currency];
                $city = $ad->city->name;
                $district = $ad->county->name;
                $neighborhood = $ad->district->name;
                $cat1 = $ad->category->typeName;
                $cat2 = $ad->mainCategory->name;
                $cat3 = $ad->subCategory->typeName;
                $phone = $ad->owner->phones[0];
                $phone = $phone->countryCode . $phone->areaCode . $phone->phoneNumber;
                $images = $ad->images;

                $url = setting_value('visiosoft.module.hurriyetemlak::ad_details_api_url');
                $curl = curl_init();
                curl_setopt_array($curl, array(
                    CURLOPT_URL => $url . '/' . $ad->listingId,
                    CURLOPT_RETURNTRANSFER => true,
                    CURLOPT_ENCODING => "",
                    CURLOPT_MAXREDIRS => 10,
                    CURLOPT_TIMEOUT => 0,
                    CURLOPT_FOLLOWLOCATION => true,
                    CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                    CURLOPT_CUSTOMREQUEST => "GET",
                    CURLOPT_HTTPHEADER => array(
                        "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36",
                    ),
                ));
                $realtyDetail = curl_exec($curl);
                curl_close($curl);
                $realtyDetail = json_decode($realtyDetail);
                $realtyDetail = (array)$realtyDetail->realtyDetail;

                $customFields = array();
                $botCustomFields = $this->fieldRepository->all();
                foreach ($botCustomFields as $botCustomField) {
                    $botCustomFieldName = explode('.', $botCustomField->field_name);
                    $fieldValue = is_object($realtyDetail[$botCustomFieldName[0]]) ?
                        (array)$realtyDetail[$botCustomFieldName[0]] : $realtyDetail[$botCustomFieldName[0]];
                    for ($i = 1; $i < count($botCustomFieldName); $i++) {
                        $fieldValue = $fieldValue[$botCustomFieldName[$i]];
                        $fieldValue = is_object($fieldValue) ? (array)$fieldValue : $fieldValue;
                    }
                    $customFields['cf' . $botCustomField->custom_field_id] = $fieldValue;
                }

                $adDetails['ad_id'] = $adId;
                $adDetails['cf_json'] = $customFields;
                $adDetails['price'] = $price;
                $adDetails['name'] = $productName;
                $adDetails['desc'] = $desc;
                $adDetails['city'] = $city;
                $adDetails['district'] = $district;
                $adDetails['neighborhood'] = $neighborhood;
                $adDetails['phone'] = $phone;
                $adDetails['images'] = $images;
                $adDetails['category'] = ['emlak', $cat2, $cat1, $cat3];

                $user = $this->checkUser($username, $phone);
                $this->postAd($adDetails, $user);

                $pageUrl->update([
                    'is_scrapped' => 1
                ]);

                $createdAds++;
            }
        }

        echo $createdAds . " ad(s) has been created!";
    }

    public function checkUser($username, $phoneNum)
    {
        $user = $this->userRepository->findBy('username', $this->str->slug($username, '_'));
        if (is_null($user)) {
            $fullName = explode(" ", $username);
            if (count($fullName) < 2) {
                $fullName[] = '';
            }
            $user = $this->userRepository->create([
                'username' => $username,
                'first_name' => $fullName[0],
                'last_name' => $fullName[1],
                'display_name' => $username,
                'email' => str_random(8) . '_' . $phoneNum . '@user.com',
                'activated' => 1,
                'gsm_phone' => $phoneNum,
            ]);
            $password = str_random(8);
            $user->setAttribute('password', $password);
            $this->userRepository->save($user);
        };

        return $user;
    }

    public function postAd($adDetails, $user)
    {
        /* Looping through the categories and creating an array of categories.. ['cat1', 'cat2', etc..] */
        $category = array();
        $noCatFound = false;
        for ($i = 0; $i < count($adDetails['category']); $i++) {
            $catNumber = $i + 1;
            $cats = $this->categoryEntryTranslationsModel->newQuery()->where('name', $adDetails['category'][$i])->get();
            if (!count($cats) && $i === 0) {
                $cat = ['id' => $this->settingRepository->value('visiosoft.module.hurriyetemlak::default_category')];
                $noCatFound = true;
            } elseif (!count($cats)) {
                $cat = ['id' => null];
                $noCatFound = true;
            } else {
                if ($i === 0) {
                    $cat = $this->categoryRepository->find($cats[0]->entry_id);
                } else {
                    foreach ($cats as $sameNameCat) {
                        $cat = $this->categoryRepository
                            ->newQuery()
                            ->where('id', $sameNameCat->entry_id)
                            ->where('parent_category_id', $category['cat' . $i])
                            ->first();
                        if ($cat) {
                            break;
                        }
                    }
                }
            }

            $category['cat' . $catNumber] = $cat['id'];
            if ($noCatFound) {
                break;
            }
        }

        $city = $this->citiesEntryTranslationsModel->newQuery()
            ->where('name', 'LIKE', $adDetails['city'] . '%')->first();
        if (is_null($city)) {
            $city = $this->settingRepository->value('visiosoft.module.location::default_city');
//            $city = $this->cityRepository->create([
//                'name' => $adDetails['city'],
//                'slug' => $this->str->slug($adDetails['city'], '_'),
//                'parent_country_id' => $this->settingRepository->value('visiosoft.module.location::default_country'),
//            ]);
        } else {
            $city = $this->cityRepository->find($city->entry_id);
            $city = $city->id;
        }

        if ($adDetails['district']) {
            $district = $this->districtsEntryTranslationsModel->newQuery()->where('name', $adDetails['district'])->first();
            if (is_null($district)) {
                $district = $this->settingRepository->value('visiosoft.module.location::default_district');
            } else {
                $district = $this->districtRepository->find($district->entry_id);
                $district = $district->id;
            }
        }

        if ($adDetails['neighborhood']) {
            $neighborhood = $this->neighborhoodsEntryTranslationsModel->newQuery()->where('name', $adDetails['neighborhood'])->first();
            if (is_null($neighborhood)) {
                $neighborhood = $this->settingRepository->value('visiosoft.module.location::default_neighborhood');
            } else {
                $neighborhood = $this->neighborhoodRepository->find($neighborhood->entry_id);
                $neighborhood = $neighborhood->id;
            }
        }

        $date = date('Y-m-d H:i:s');
        $data = [
            'name' => $adDetails['name'],
            'advs_desc' => $adDetails['desc'],
            'price' => $adDetails['price'][0],
            'country_id' => $this->settingRepository->value('visiosoft.module.location::default_country'),
            'city' => $city,
            'slug' => $adDetails['name'] . '_' . $adDetails['ad_id'],
            'currency' => $adDetails['price'][1],
            'created_by_id' => $user->id,
            'status' => 'approved',
            'publish_at' => $date,
            'finish_at' => date('Y-m-d H:i:s', strtotime($date . ' + 60 day')),
        ];

        // Add district if not null
        if ($adDetails['district']) {
            $data['district'] = $district;
        }

        // Add neighborhood if not null
        if ($adDetails['neighborhood']) {
            $data['neighborhood'] = $neighborhood;
        }

        $adv = $this->advRepository
            ->newQuery()
            ->where('slug', 'LIKE', '%_' . $adDetails['ad_id'])
            ->first();
        if (is_null($adv)) {
            $adv = $this->advRepository->create(array_merge($data, $category));
            $adImages = $this->savePhoto($adDetails['images'], $adv->id);
            if (count($adImages) > 0) {
                $adv->update([
                    'cover_photo' => $adImages[0]->url()
                ]);
            }
        } else {
            $adv->update(array_merge($data, $category));
        }

        $jsonCustomFields = $this->createCustomFields($adDetails['cf_json'], $adv);
        $adv->update([
            'cf_json' => $jsonCustomFields
        ]);
    }

    public function createCustomFields($customFields, $ad)
    {
        $jsonCustomFields = array();
        foreach ($customFields as $customFieldId => $customFieldValue) {
            $customFieldType = $this->customFieldRepository->find(substr($customFieldId, 2));
            if (!is_null($customFieldType)) {
                if ($customFieldType->type === 'select' || $customFieldType->type === 'radio') {
                    $selectValue = $this->cfvalueEntryTranslationsModel
                        ->newQuery()
                        ->where('custom_field_value', 'LIKE', "%$customFieldValue%")
                        ->first();
                    if (is_null($selectValue)) {
                        $selectValue = $this->cfvalueRepository->create([
                            'custom_field' => $customFieldType,
                            'custom_field_value' => $customFieldValue
                        ]);
                        $selectValue = $selectValue->id;
                    } else {
                        $selectValue = $selectValue->entry_id;
                    }
                    $customFieldValue = $selectValue;
                } elseif ($customFieldType->type === 'checkboxes') {
                    $values = array();
                    foreach ($customFieldValue as $value) {
                        $valueNoWhitespace = preg_replace('/\s+/', '', $value->name);
                        $checkboxValues = $this->cfvalueEntryTranslationsModel
                            ->newQuery()
                            ->whereRaw("REPLACE(custom_field_value, ' ', '') = REPLACE(\"$valueNoWhitespace\", ' ', '')")
                            ->get();
                        if ($checkboxValues) {
                            $trueValue = null;
                            foreach ($checkboxValues as $checkboxValue) {
                                $cBValue = $this->cfvalueRepository->find($checkboxValue->entry_id);
                                if (is_null($cBValue)) {
                                    $checkboxValue->delete();
                                } elseif ($cBValue->custom_field_id === (int)substr($customFieldId, 2)) {
                                    if (!is_null($trueValue)) {
                                        $checkboxValue->delete();
                                        $cBValue->delete();
                                    } else {
                                        $trueValue = $cBValue;
                                    }
                                }
                            }
                            if (is_null($trueValue)) {
                                $trueValue = $this->cfvalueRepository->create([
                                    'custom_field' => $customFieldType,
                                    'custom_field_value' => $valueNoWhitespace
                                ]);
                            }
                            $values[] = $trueValue->id;
                        }
                    }
                    $customFieldValue = $values;
                }

                if ($customFieldType->type === 'checkboxes') {
                    $this->customFieldAdvRepository
                        ->newQuery()
                        ->where('parent_adv_id', $ad->id)
                        ->where('custom_field_category_id', $customFieldType->id)
                        ->where('custom_field_type', $customFieldType->type)
                        ->delete();
                    $customField = $this->customFieldAdvRepository->create([
                        'parent_adv' => $ad,
                        'custom_field_category' => $customFieldType,
                        'custom_field_value' => json_encode($customFieldValue),
                        'custom_field_type' => $customFieldType->type
                    ]);
                    $jsonCustomFields[$customFieldId] = $customFieldValue;
                } else {
                    $this->customFieldAdvRepository
                        ->newQuery()
                        ->where('parent_adv_id', $ad->id)
                        ->where('custom_field_category_id', $customFieldType->id)
                        ->where('custom_field_type', $customFieldType->type)
                        ->delete();
                    $customField = $this->customFieldAdvRepository->create([
                        'parent_adv' => $ad,
                        'custom_field_category' => $customFieldType,
                        'custom_field_value' => $customFieldValue,
                        'custom_field_type' => $customFieldType->type
                    ]);
                    $jsonCustomFields[$customFieldId] = $customField->id;
                }
            }
        }
        $jsonCustomFields = json_encode($jsonCustomFields, JSON_UNESCAPED_UNICODE);
        return $jsonCustomFields;
    }

    public function savePhoto($photosUrl, $advId)
    {
        $adImages = array();
        /* Looping through the photo's URLs and saving them */
        if ($photosUrl) {
            foreach ($photosUrl as $photoUrl) {
                $link = 'https://cdn01.hemlak.com/' . $photoUrl;
                $name = basename($link);
                $contents = $this->curlGetContents($link);
                $target = base_path() . "/storage/streams/default/files-module/local/images/" . $name;
                /* Saving the photos in the local storage */
                file_put_contents($target, $contents);
                $file = $this->saveFileInModel($name);
                DB::table('advs_advs_files')->insert(
                    ['file_id' => $file->id, 'entry_id' => $advId]
                );
                $adImages[] = $file;
            }
        }
        return $adImages;
    }

    public function curlGetContents($url)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch,CURLOPT_USERAGENT,'Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.13) Gecko/20080311 Firefox/2.0.0.13');
        $data = curl_exec($ch);
        curl_close($ch);
        return $data;
    }

    public function saveFileInModel($filename)
    {
        return $this->fileRepository->create([
            'folder_id' => 1,
            'name' => $filename,
            'disk_id' => 1,
            'size' => 1,
            'mime_type' => "image/jpeg",
            'extension' => 1,
        ]);
    }

}
