<?php namespace Visiosoft\HurriyetemlakModule\Traits;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Support\Facades\Validator;
use Nesk\Puphpeteer\Puppeteer;
use Nesk\Rialto\Data\JsFunction;
use Visiosoft\HurriyetemlakModule\Pagination\Contract\PaginationRepositoryInterface;

trait ProductTrait
{
    protected $messages;

    public function __construct()
    {
        set_time_limit(0);
        $this->messages = app('Anomaly\Streams\Platform\Message\MessageBag');
    }

    public function index(FormBuilder $form)
    {
        if (\request()->action == "save") {
            $validator = Validator::make(\request()->all(), [
                'url' => 'required|url',
            ]);

            if ($validator->fails()) {
                $this->messages->error($validator->messages()->first());
                return redirect()->back();
            }

            $response = $this->getPaginationLinks(\request()->url, \request()->type);
            $this->messages->success(trans('visiosoft.module.hurriyetemlak::message.get_pagination_success', ['number' => $response]));
            return redirect()->back();
        }
        $form->setActions(['save']);
        $form->setFields([
            'url' => 'anomaly.field_type.url',
        ]);
        return $form->render();
    }

    public function getPaginationLinks($url, $type = 'admin')
    {
        $host = parse_url($url);
        if (isset($host['path'])) {
            $path = $host['path'];
        } else {
            $this->messages->error(trans('module::message.url_not_correct'));
        }
        $query = isset($host['query']) ? $host['query'] : '';
        if (!empty($query)) { // Get starting page
            parse_str($query, $queryArray);
            $startPage = isset($queryArray['page']) ? $queryArray['page'] : 1;
            unset($queryArray['page']); // Unset the page param to reuse the query
        } else {
            $startPage = 1;
        }

        $puppeteer = new Puppeteer;

        $browser = $puppeteer->launch();
        $page = $browser->newPage();

        $page->goto(setting_value('visiosoft.module.hurriyetemlak::api_url') . $path . '?' . $query);
        $page->screenshot(['path' => '1.png']);
        $page->waitForSelector('body > pre', ['visible' => true ]);
        $page->screenshot(['path' => '2.png']);

        $response = $page->evaluate(JsFunction::createWithBody("
            let jsonData = document.querySelector('pre');
            jsonData = jsonData ? jsonData.textContent : null
            return JSON.parse(jsonData)
        "));

        $browser->close();

        if (isset($response->errors)) {
            foreach ($response->errors as $error) {
                $this->messages->error($error);
            }
            return redirect()->back();
        }

        $numOfPages = $response['totalPages'] - $startPage == 0 ? 1 : $response['totalPages'] - $startPage;
        if ($numOfPages > setting_value('visiosoft.module.hurriyetemlak::pagination_limit')) {
            $numOfPages = setting_value('visiosoft.module.hurriyetemlak::pagination_limit');
        } elseif ($response['totalPages'] - $startPage != 0) {
            $numOfPages++;
        }
        $numOfLoops = $numOfPages + $startPage;

        $query = !empty($query) ? http_build_query($queryArray) . '&' : $query;
        for ($startPage; $startPage < $numOfLoops; $startPage++) {
            $data = [
                'url' => setting_value('visiosoft.module.hurriyetemlak::api_url')
                    . $path . '?' . $query . 'page=' . $startPage,
            ];

            if ($type === 'user') {
                $data['user'] = auth()->id();
            }

            app(PaginationRepositoryInterface::class)->create($data);
        }

        return $numOfPages;
    }
}
