<?php namespace Visiosoft\HurriyetemlakModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Illuminate\Http\Request;
use Visiosoft\BotModule\Http\Controller\ScrapesController;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\HurriyetemlakModule\Pagination\Contract\PaginationRepositoryInterface;

class ProductController extends AdminController
{
    private $settingRepository;
    private $paginationRepository;
    private $scrapesController;

    public function __construct(
        SettingRepositoryInterface $settingRepository,
        PaginationRepositoryInterface $paginationRepository,
        ScrapesController $scrapesController
    )
    {
        set_time_limit(0);
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->paginationRepository = $paginationRepository;
        $this->scrapesController = $scrapesController;
    }

    public function index(FormBuilder $form, Request $request)
    {
        if ($request->action == "save") {
            $response = $this->getPaginationLinks($request->url);
            $this->messages->success(trans('visiosoft.module.hurriyetemlak::message.get_pagination_success', ['number' => $response]));
            return redirect('/admin/hurriyetemlak');
        }
        $form->setActions(['save']);
        $form->setFields([
            'url' => 'anomaly.field_type.url',
        ]);
        return $form->render();
    }

    public function getPaginationLinks($url)
    {
        $pageLinks = array($url);
        $host = parse_url($url);
        if (isset($host['path'])) {
            $path = $host['path'];
        } else {
            $this->messages->error(trans('module::message.url_not_correct'));
        }
        $query = isset($host['query']) ? $host['query'] : '';
        if (!empty($query)) { // Get starting page
            parse_str($query, $queryArray);
            $startPage = isset($queryArray['page']) ? $queryArray['page'] : 1;
            unset($queryArray['page']); // Unset the page param to reuse the query
        } else {
            $startPage = 1;
        }
        $domain = $host['scheme'] . '://' . $host['host'];

        $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => setting_value('visiosoft.module.hurriyetemlak::api_url') . $path . '?' . $query,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => "",
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => "GET",
            CURLOPT_HTTPHEADER => array(
                "user-agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.149 Safari/537.36",
            ),
        ));
        $response = curl_exec($curl);
        curl_close($curl);
        $response = json_decode($response);

        if (isset($response->errors)) {
            foreach ($response->errors as $error) {
                $this->messages->error($error);
            }
            return redirect()->back();
        }

        $numOfPages = $response->totalPages - $startPage == 0 ? 1 : $response->totalPages - $startPage;
        if ($numOfPages > setting_value('visiosoft.module.hurriyetemlak::pagination_limit')) {
            $numOfPages = setting_value('visiosoft.module.hurriyetemlak::pagination_limit');
        } elseif ($response->totalPages - $startPage != 0) {
            $numOfPages++;
        }
        $numOfLoops = $numOfPages + $startPage;

        $query = !empty($query) ? http_build_query($queryArray) . '&' : $query;
        for ($startPage; $startPage < $numOfLoops; $startPage++) {
            $this->paginationRepository->create([
                'url' => setting_value('visiosoft.module.hurriyetemlak::api_url')
                    . $path . '?' . $query . 'page=' . $startPage
            ]);
        }

        return $numOfPages;
    }

    public function cron()
    {
        return $this->view->make('visiosoft.module.hurriyetemlak::cron');
    }

}
