<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleHurriyetemlakCreateFieldsStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'fields',
        'title_column' => 'field_name',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'custom_field' => [
            'unique' => true,
            'required' => true,
        ],
        'field_name' => [
            'unique' => true,
            'required' => true,
        ],
    ];

}
