<?php namespace Visiosoft\HprojectsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\HprojectsModule\Project\Contract\ProjectRepositoryInterface;

class ProjectsController extends PublicController
{
    private $projectRepository;

    public function __construct(ProjectRepositoryInterface $projectRepository)
    {
        parent::__construct();
        $this->projectRepository = $projectRepository;
    }

    public function index()
    {
        try {
            $keyword = request()->keyword;
            $perPage = setting_value('streams::per_page');

            if ($keyword) {
                $projects = $this->projectRepository->filterProjects($keyword);
            } else {
                $projects = $this->projectRepository->newQuery();
            }

            $projects = $projects->paginate($perPage);

            if (!$projects->total()) {
                throw new \Exception(trans('visiosoft.module.hprojects::message.packages_not_found'));
            }

            return view('visiosoft.module.hprojects::list')->with('projects', $projects);
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('visiosoft.module.hprojects::list');
        }
    }

    public function detail($projectSlug)
    {
        try {
            $project = $this->projectRepository->findBySlug($projectSlug);

            if (!$project) {
                throw new \Exception(trans('visiosoft.module.hprojects::message.package_doesnt_exist'));
            }

            return view('visiosoft.module.hprojects::detail')->with('project', $project);
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('visiosoft.module.hprojects::index');
        }
    }
}
