<?php namespace Visiosoft\HprojectsModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Hprojects\HprojectsProjectsEntryModel;
use Visiosoft\HprojectsModule\Project\Contract\ProjectRepositoryInterface;
use Visiosoft\HprojectsModule\Project\ProjectModel;
use Visiosoft\HprojectsModule\Project\ProjectRepository;

class HprojectsModuleServiceProvider extends AddonServiceProvider
{
    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        // Admin ProjectsController
        'admin/hprojects'           => 'Visiosoft\HprojectsModule\Http\Controller\Admin\ProjectsController@index',
        'admin/hprojects/create'    => 'Visiosoft\HprojectsModule\Http\Controller\Admin\ProjectsController@create',
        'admin/hprojects/edit/{id}' => 'Visiosoft\HprojectsModule\Http\Controller\Admin\ProjectsController@edit',

        // ProjectsController
        'projects' => [
            'as' => 'visiosoft.module.hprojects::list',
            'uses' => 'Visiosoft\HprojectsModule\Http\Controller\ProjectsController@index',
        ],
        'project/{slug}' => [
            'as' => 'visiosoft.module.hprojects::detail',
            'uses' => 'Visiosoft\HprojectsModule\Http\Controller\ProjectsController@detail',
        ],

        // ApiController
        'api/find-house' => [
            'as' => 'visiosoft.module.hprojects::api_find_house',
            'uses' => 'Visiosoft\HprojectsModule\Http\Controller\ApiController@findHouse',
        ],
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        HprojectsProjectsEntryModel::class => ProjectModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        ProjectRepositoryInterface::class => ProjectRepository::class,
    ];
}
