// Main swiper
const mySwiper = new Swiper('.project-gallery-swiper', {
    loop: true,
    slidesPerView: 'auto',
    centeredSlides: true,

    autoplay: {
        delay: 3500,
        disableOnInteraction: true,
    },

    navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev',
    },
})

// Google maps
$(document).ready(function(){
    $('#showMap').on('click', initializeMap)
    $('#showStreet').on('click', initializeStreet)
    $('#showGallery').on('click', initializeGallery)
});

function initializeMap() {
    const mapCanvas = $('#mapCanvas')

    activateNav(this)
    changeView(mapCanvas)

    if (!mapCanvas.hasClass('initialized')) {
        const coordinates = getCoordinates()
        const mapOptions = {
            center: coordinates,
            zoom: 15
        };
        const map = new google.maps.Map(document.getElementById('mapCanvas'), mapOptions);

        mapCanvas.addClass('initialized')
    }
}

function initializeStreet() {
    const streetCanvas = $('#streetCanvas')

    activateNav(this)
    changeView(streetCanvas)

    if (!streetCanvas.hasClass('initialized')) {
        const coordinates = getCoordinates()
        const panorama = new google.maps.StreetViewPanorama(
            document.getElementById("streetCanvas"),
            {
                position: coordinates,
                pov: {
                    heading: 34,
                    pitch: 10,
                },
            }
        );

        streetCanvas.addClass('initialized')
    }
}

function initializeGallery() {
    activateNav(this)
    changeView($('#projectGallery'))
}

const views = ['#streetCanvas', '#mapCanvas', '#projectGallery']
const changeView = (view) => {
    $(views.toString()).hide()
    view.show()
}

const getCoordinates = () => {
    let coordinates = $('#mapCanvas').data('coordinates')
    if (coordinates) {
        coordinates = coordinates.split(',')
        coordinates = { lat: Number(coordinates[0]), lng: Number(coordinates[1]) }
    } else {
        coordinates = null
    }
    return coordinates
}

const activateNav = (navItem) => {
    $(navItem).addClass('active').siblings().removeClass('active')
}

// Add smooth scrolling
$("a").on('click', function (event) {
    if (this.hash !== "") {
        event.preventDefault();

        const hash = this.hash;

        $('html, body').animate({
            scrollTop: $(hash).offset().top
        }, 500, function () {
            window.location.hash = hash;
        });
    }
});

// Submit find home form
$('.find-home-form').submit(function(e) {
    e.preventDefault();

    const form = $(this)
    const formButton = form.children('button');
    const buttonText = formButton.html();

    form.siblings('.form-error-alert').hide();
    formButton.prop('disabled', true).html('<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span>');

    $.ajax({
        type: 'POST',
        data: form.serialize(),
        url: findHouseRoute,
        success: function (response) {
            if (response['status'] === 'success') {
                form.siblings('.form-success').removeClass('hidden');
                form.hide().siblings('.form-error-alert').hide();
            } else {
                handleError()
            }
        },
        error: function () {
            handleError()
        }
    });

    const handleError = () => {
        form.siblings('.form-error-alert').show();
        formButton.prop('disabled', false).html(buttonText);
    }
});

// Restricts input for the given textbox to the given inputFilter function.
function setInputFilter(textboxs, inputFilter) {
    ["input", "keydown", "keyup", "mousedown", "mouseup", "select", "contextmenu", "drop"].forEach(function(event) {
        textboxs.forEach(function (textbox) {
            textbox.addEventListener(event, function() {
                if (inputFilter(this.value)) {
                    this.oldValue = this.value;
                    this.oldSelectionStart = this.selectionStart;
                    this.oldSelectionEnd = this.selectionEnd;
                } else if (this.hasOwnProperty("oldValue")) {
                    this.value = this.oldValue;
                    this.setSelectionRange(this.oldSelectionStart, this.oldSelectionEnd);
                } else {
                    this.value = "";
                }
            });
        })
    });
}

setInputFilter(document.querySelectorAll("[name=cell_phone]"), function(value) {
    return /^\d*\.?\d*$/.test(value);
});
