<?php namespace Visiosoft\HprojectsModule\Project;

use Visiosoft\HprojectsModule\Project\Contract\ProjectRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class ProjectRepository extends EntryRepository implements ProjectRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var ProjectModel
     */
    protected $model;

    /**
     * Create a new ProjectRepository instance.
     *
     * @param ProjectModel $model
     */
    public function __construct(ProjectModel $model)
    {
        $this->model = $model;
    }

    public function filterProjects($keyword)
    {
        return $this->newQuery()
            ->join('advs_advs as advs', 'hprojects_projects.adv_id', '=', 'advs.id')
            ->join('advs_advs_translations as advs_trans', 'advs.id', '=', 'advs_trans.entry_id')
            ->where('name', 'LIKE', "%$keyword%")
            ->groupBy(['advs_trans.entry_id']);
    }

    public function findBySlug($slug)
    {
        return $this->newQuery()
            ->join('advs_advs as advs', 'hprojects_projects.adv_id', '=', 'advs.id')
            ->where('slug', $slug)
            ->first();
    }
}
