<?php namespace Visiosoft\HprojectsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\HprojectsModule\Project\Contract\ProjectRepositoryInterface;
use Visiosoft\HprojectsModule\Slider\Contract\SliderRepositoryInterface;

class ProjectsController extends PublicController
{
    private $projectRepository;
    private $sliderRepository;

    public function __construct(
        ProjectRepositoryInterface $projectRepository,
        SliderRepositoryInterface $sliderRepository
    )
    {
        parent::__construct();
        $this->projectRepository = $projectRepository;
        $this->sliderRepository = $sliderRepository;
    }

    public function index()
    {
        try {
            $keyword = request()->keyword;
            $perPage = setting_value('streams::per_page');

            if ($keyword) {
                $projects = $this->projectRepository->filterProjects($keyword);
            } else {
                $projects = $this->projectRepository->newQuery();
            }

            $projects = $projects->paginate($perPage);

            if (!$projects->total() && $keyword) {
                throw new \Exception(trans('visiosoft.module.hprojects::message.packages_not_found'));
            }

            $sliders = $this->sliderRepository->all();

            return view('visiosoft.module.hprojects::list', compact('projects', 'sliders'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('visiosoft.module.hprojects::list');
        }
    }

    public function detail($projectSlug)
    {
        try {
            $project = $this->projectRepository->findBySlug($projectSlug);

            if (!$project) {
                throw new \Exception(trans('visiosoft.module.hprojects::message.package_doesnt_exist'));
            }

            return view('visiosoft.module.hprojects::detail')->with('project', $project);
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('visiosoft.module.hprojects::index');
        }
    }
}
