<?php namespace Visiosoft\HprojectsModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Anomaly\UsersModule\Role\Contract\RoleRepositoryInterface;
use Illuminate\Support\Facades\Notification;
use Visiosoft\HprojectsModule\Http\Requests\FindHouseRequest;
use Visiosoft\HprojectsModule\Events\SendFindHouse;

class ApiController extends PublicController
{
    private $notification;
    private $roleRepository;

    public function __construct(Notification $notification, RoleRepositoryInterface $roleRepository)
    {
        parent::__construct();
        $this->notification = $notification;
        $this->roleRepository = $roleRepository;
    }

    public function findHouse(FindHouseRequest $request)
    {
        try {
            $request->validated();

            event(new SendFindHouse($request->all()));

            return ['status' => 'success'];
        } catch (\Exception $e) {
            return ['status' => 'error'];
        }
    }
}
