<?php namespace Visiosoft\HomeCategoriesExtension;

use Anomaly\NavigationModule\Link\Contract\LinkRepositoryInterface;
use Anomaly\NavigationModule\Menu\Contract\MenuRepositoryInterface;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\Repeater1To2HomeCategoriesEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterOneToTwoHomeCategoriesEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class HomeCategoriesExtensionSeeder extends Seeder
{
    private $settingRepository;
    private $streamRepository;
    private $fieldRepository;
    private $assignmentRepository;
    private $menus;
    private $links;

    public function __construct(
        SettingRepositoryInterface $settingRepository,
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        MenuRepositoryInterface $menus,
        LinkRepositoryInterface $links
    )
    {
        parent::__construct();
        $this->settingRepository = $settingRepository;
        $this->streamRepository = $streamRepository;
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->menus = $menus;
        $this->links = $links;
    }

    public function run()
    {
        // Create repeaters
        $repeaters = [
            [
                'name' => '1/2 Home Categories',
                'slug' => 'one_to_two_home_categories',
                'translatable' => false,
            ],
        ];

        $repeaters_objects = array();

        foreach ($repeaters as $repeater) {
            $exists = $this->streamRepository->findBySlugAndNamespace($repeater['slug'], 'repeater');
            $repeaters_objects[$repeater['slug']] = $exists ?: $this->streamRepository->create([
                'name' => $repeater['name'],
                'namespace' => 'repeater',
                'slug' => $repeater['slug'],
                'prefix' => 'repeater_',
                'translatable' => $repeater['translatable'],
            ]);
        }

        // Assign repeater fields
        $repeaters_fields = [
            [
                'name' => 'Image',
                'namespace' => 'repeater',
                'slug' => 'image',
                'repeater_slug' => 'one_to_two_home_categories',
                'type' => 'anomaly.field_type.file',
                "config" => [
                    "folders" => ['images'],
                    "mode" => 'upload',
                ],
                "assignmentConfig" => [
                    "required" => true,
                    "translatable" => false,
                ],
            ],
            [
                'name' => 'Link',
                'namespace' => 'repeater',
                'repeater_slug' => 'one_to_two_home_categories',
                'slug' => 'link',
                'type' => 'anomaly.field_type.url',
                "config" => [
                    "default_value" => '#',
                ],
                "assignmentConfig" => [
                    "required" => true,
                ],
            ],
        ];

        foreach ($repeaters_fields as $repeaters_field) {

            $field = $this->fieldRepository->findBySlugAndNamespace($repeaters_field['slug'], 'repeater');

            // Create Field
            if (!$field) {
                $fieldValue = [
                    'name' => $repeaters_field['name'],
                    'namespace' => 'repeater',
                    'slug' => $repeaters_field['slug'],
                    'type' => $repeaters_field['type'],
                    'locked' => 0,
                ];

                if (isset($repeatersField['config'])) {
                    $fieldValue['config'] = $repeaters_field['config'];
                }

                if (isset($repeatersField['instructions'])) {
                    $fieldValue['instructions'] = $repeaters_field['instructions'];
                }

                $field = $this->fieldRepository->create($fieldValue);
            }

            // Create Assign
            $assign = $this->assignmentRepository->findByStreamAndField(
                $repeaters_objects[$repeaters_field['repeater_slug']],
                $field
            );

            if (!$assign) {
                $this->assignmentRepository->create(array_merge([
                    'stream_id' => $repeaters_objects[$repeaters_field['repeater_slug']]->getId(),
                    'field_id' => $field->getId(),
                ], $repeaters_field['assignmentConfig']));
            }
        }

        // Assign Pages fields
        $default_pages_stream = $this->streamRepository->findBySlugAndNamespace('default_pages', 'pages');

        $pagesFields = [
            [
                'name' => '1/2 Home Categories',
                'slug' => 'one_to_two_home_categories',
                "config" => [
                    "related" => RepeaterOneToTwoHomeCategoriesEntryModel::class,
                ]
            ],
        ];

        foreach ($pagesFields as $pagesField) {

            $field = $this->fieldRepository->findBySlugAndNamespace($pagesField['slug'], 'pages');

            if (!$field) {
                $field = $this->fieldRepository->create([
                    'name' => $pagesField['name'],
                    'namespace' => 'pages',
                    'slug' => $pagesField['slug'],
                    'type' => 'anomaly.field_type.repeater',
                    'locked' => 0,
                    "config" => $pagesField['config']
                ]);
            }

            $assign = $this->assignmentRepository->findByStreamAndField($default_pages_stream, $field);

            if (!$assign) {
                $this->assignmentRepository->create([
                    'stream_id' => $default_pages_stream->getId(),
                    'field_id' => $field->id,
                ]);
            }
        }
    }
}
