var current_page = 1;
var ads_type = "";

var objJson = [];
let totalAdvs = 0

function prevPage() {
    if (current_page > 1) {
        current_page--;
        getMyAdvs(ads_type)
    }
}

function nextPage(event) {
    if (current_page < numPages()) {
        current_page++;
        getMyAdvs(ads_type)
    }
}

function changePage(page) {

    var btn_next = $("#btn_next");
    var btn_prev = $("#btn_prev");
    if (ads_type == 'approved') {
        var listing_table = $("#v-pills-active_ads");
        listing_table.html(approved_info);
    } else if (ads_type == 'pending') {
        var listing_table = $("#v-pills-pending_ads");
        listing_table.html(pending_info);
    } else if (ads_type == 'passive') {
        var listing_table = $("#v-pills-passive_ads");
        listing_table.html(passive_info);
    } else if (ads_type == 'incomplete') {
        var listing_table = $("#v-pills-incomplete_ads");
        listing_table.html(incomplete_info);
    }
    var page_span = $("#page");

    // Validate page
    if (page < 1) page = 1;
    if (page > numPages()) page = numPages();


    if (objJson.length === 0) {
        listing_table.html(`
            <div class="alert alert-warning" role="alert">
                ${no_ads_message}
            </div>
        `);
    }

    for (var i = 0; i < objJson.length; i++) {
        listing_table.append(addAdsRow(objJson[i].id, objJson[i].detail_url, objJson[i].cover_photo, objJson[i].name,
            objJson[i].formatted_price, objJson[i].city_name, objJson[i].country_name, objJson[i].cat1_name,
            objJson[i].cat2_name, objJson[i].status, objJson[i].created_at));
    }


    page_span.html(page + "/" + numPages());

    if (numPages() === 1) {
        page_span.hide();
    } else {
        page_span.show();
    }

    if (page === 1) {
        btn_prev.hide();
    } else {
        btn_prev.show();
    }

    if (page === numPages()) {
        btn_next.hide();
    } else {
        btn_next.show();
    }
}

function numPages() {
    return Math.ceil(totalAdvs / records_per_page);
}

function getMyAdvs(type) {
    crudAjax({
        'type': type,
        'paginate': true,
        'page': current_page,
        'simple': true
    }, '/ajax/getAdvs', 'GET', function (callback) {
        ads_type = type;
        objJson = callback.content.data;
        totalAdvs = callback.content.total;
        changePage(current_page);
    })
}

$('#v-pills-tab a').on('click', function () {
    current_page = 1
    $('.profile_ads_pagination').removeClass('d-none');
    if ($(this).attr('data-type') == 'active_ads') {
        getMyAdvs("approved");
    } else if ($(this).attr('data-type') == 'passive_ads') {
        getMyAdvs("passive");
    } else if ($(this).attr('data-type') == 'pending_ads') {
        getMyAdvs("pending");
    } else if ($(this).attr('data-type') == 'incomplete_ads') {
        getMyAdvs("incomplete");
    }
});

const urlString = window.location.href;
const url = new URL(urlString);
let type = url.searchParams.get("type");
type = type ? type : 'approved';
getMyAdvs(type);


function addAdsRow(id, href, image, name, formatted_price, city, country, cat1, cat2, status, created_at) {
    city = (city) ? city : '';
    country = (country) ? country : '';
    return `
            <div class="d-flex flex-lg-row flex-column p-sm-3 p-0 pb-sm-3 pb-3 productOut mt-3">
            <div class="productAdvs_Image position-relative col-lg-2 p-0">
                <img class='img-thumbnail' src='${image}' alt='${name}'>
            </div>
            <div class="productAdvsText_Area d-flex flex-column ml-sm-2 ml-0 p-sm-0 p-2 flex-grow-1 justify-content-between mt-lg-0 mt-3 col-lg-9">
                <div class="d-flex justify-content-between flex-md-row flex-column">
                    <div class="d-flex flex-column overflow-hidden">
                        <div class="text_2">${name ? name : ''}</div>
                        <div class="flex-wrap d-sm-flex d-none">
                            <div class="mb-2 align-items-center d-flex">
                                <div class="font-weight-bold color_8 text_3 fs-14">
                                    ${formatted_price}
                                </div>
                                <div class="lineGap"></div>
                            </div>
                        </div>
                        <div class="fs-14 color_9 mb-sm-0 mb-3">${created_at_text} : &nbsp; ${created_at.slice(0, 10).replaceAll('-', '.')}
                        </div>
                    </div>
                </div>
                <div class="d-flex justify-content-end align-items-center mt-2">
                      ${dropdownRow(id, status)}
                </div>
            </div>
            </div>
    `;
}

function dropdownRow(id, type) {
    var dropdown = "<div class='dropdown my-ads-dropdown' data-id='" + id + "'>\n" +
        "  <button class='dropdown-toggle btn btn-outline-dark border-0' type='button' id='dropdownMenuButton' data-toggle='dropdown'>\n" +
        choose_text +
        "  </button>\n" +
        "  <div class='dropdown-menu' aria-labelledby='dropdownMenuButton'>\n";
    if (type == "passive") {
        dropdown += "<a class='dropdown-item text-success' href='/advs/status/" + id + ",approved'>" +
            "<i class='fas fa-eye'></i> " +
            approve +
            "</a>\n";
    } else {
        dropdown += "<a class='dropdown-item text-secondary' href='/advs/status/" + id + ",passive'>" +
            "<i class='fas fa-eye-slash'></i> " +
            passive +
            "</a>\n";
    }

    dropdown += "<a class='dropdown-item text-primary' href='/advs/edit_advs/" + id + "'>" +
        "<i class='fas fa-pencil-alt'></i> " +
        edit_ad +
        "</a>\n";

    dropdown += "<a class='dropdown-item text-danger' href='/advs/delete/" + id + "'>" +
        "<i class='fas fa-trash'></i> " +
        delete_ad +
        "</a>\n";

    if (Object.keys(userStatus).length) {
        let statusItems = ''
        for (const status in userStatus) {
            statusItems += `
            <li>
                <a class="dropdown-item"
                    href="${statusChangeLink.replace(':adID', id).replace(':statusID', status)}">
                    ${userStatus[status]}
                </a>
            </li>
        `
        }

        dropdown += `
        <li class="dropdown-submenu dropleft">
            <button type="button" class="btn dropdown-item dropdown-toggle">${changeStatusTrans}</button>
            <ul class="dropdown-menu">
                ${statusItems}
            </ul>
          </li>
        `;
    }

    dropdown += "</div></div>";

    return dropdown;
}

// Nested dropdown
$('.tab-pane').on('click', '.dropdown-menu button.dropdown-toggle', function (e) {
    if (!$(this).next().hasClass('show')) {
        $(this).parents('.dropdown-menu').first().find('.show').removeClass('show');
    }
    var $subMenu = $(this).next('.dropdown-menu');
    $subMenu.toggleClass('show');

    $(this).parents('.my-ads-dropdown.show').on('hidden.bs.dropdown', function (e) {
        $('.dropdown-submenu .show').removeClass('show');
    });

    return false;
});
