$('.burger-header-area').on('click', () => {
    $(".burger").toggleClass("show");
    $(".burger-side").toggleClass("show");
    $(".burger-other").toggleClass("show");
})

$('.burger-other').on('click', () => {
    $(".burger").toggleClass("show");
    $(".burger-side").toggleClass("show");
    $(".burger-other").toggleClass("show");
})

$("body").tooltip({ selector: '[data-toggle=tooltip]', template: '<div class="tooltip" role="tooltip"><div class="arrow"></div><div class="tooltip-inner"></div></div>'});

$('.slider').slick({
    dots: false,
    infinite: true,
    speed: 300,
    slidesToShow: 4,
    slidesToScroll: 4,
    responsive: [
        {
            breakpoint: 1400,
            settings: {
                slidesToShow: 3,
                slidesToScroll: 3,
                infinite: true,
                dots: true
            }
        },
        {
            breakpoint: 992,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2
            }
        },
        {
            breakpoint: 768,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }]
});

$('.sliderTwo').slick({
    dots: true,
    infinite: false,
    speed: 300,
    slidesToShow: 3,
    slidesToScroll: 3,
    responsive: [
        {
            breakpoint: 992,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2,
                infinite: true,
                dots: true
            }
        },
        {
            breakpoint: 768,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }]
});

$('.sliderThree').slick({
    dots: true,
    infinite: false,
    speed: 300,
    slidesToShow: 2,
    slidesToScroll: 3,
    responsive: [
        {
            breakpoint: 992,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2,
                infinite: true,
                dots: true
            }
        },
        {
            breakpoint: 768,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }]
});

$('.sliderFour').slick({
    dots: false,
    infinite: true,
    speed: 300,
    slidesToShow: 3,
    slidesToScroll: 3,
    asNavFor: '.sliderFive',
    centerMode: false,
    focusOnSelect: true,
    fade: false,
    responsive: [
        {
            breakpoint: 1400,
            settings: {
                slidesToShow: 2,
                slidesToScroll: 2,
                infinite: true,
                dots: true
            }
        },
        {
            breakpoint: 1200,
            settings: {
                slidesToShow: 1,
                slidesToScroll: 1
            }
        }]
});

$('.sliderFive').slick({
    dots: false,
    fade: false,
    speed: 0,
    infinite: true,
    slidesToShow: 1,
    slidesToScroll: 1,
    asNavFor: '.sliderFour',
});

$('.floating-group').find('.floating-control').each(function (index, ele) {
    var $ele = $(ele);
    if ($ele.val() != '' || $ele.is(':selected') === true) {
        $ele.parents('.floating-group').addClass('focused');
    }
})


$('.floating-control').on('focus', function (e) {
    $(this).parents('.floating-group').addClass('focused');
}).on('blur', function () {
    if ($(this).val().length > 0) {
        $(this).parents('.floating-group').addClass('focused');
    } else {
        $(this).parents('.floating-group').removeClass('focused');
    }
});
$('.floating-control').on('change', function (e) {
    if ($(this).is('select')) {
        if ($(this).val() === $("option:first", $(this)).val()) {
            $(this).parents('.floating-group').removeClass('focused');
        } else {
            $(this).parents('.floating-group').addClass('focused');
        }
    }
})

$(document).ready(function () {
    $('.customSelect').each(function () {
        var dropdownParents = $(this).parents('.select2Part')
        $(this).select2({
            dropdownParent: dropdownParents,
            minimumResultsForSearch: -1
        }).on("select2:open", function (e) {
            $(this).parents('.floating-group').addClass('focused');
        }).on("select2:close", function (e) {
            if ($(this).find(':selected').val() === '') {
                $(this).parents('.floating-group').removeClass('focused');
            }
        });
    });

    $('.customSelectMultiple').each(function () {
        var dropdownParents = $(this).parents('.select2Part');
        $(this).select2({
            dropdownParent: dropdownParents,
        }).on("select2:open", function (e) {
            $(this).parents('.floating-group').addClass('focused');
        }).on("select2:close", function (e) {
            if ($(this).val() != '') {
                $(this).parents('.floating-group').addClass('focused');
            } else {
                $(this).parents('.floating-group').removeClass('focused');
            }
        }).on("select2:select", function (e) {
            $(this).parents('.floating-group').addClass('focused');
        }).on("select2:unselect", function (e) {
            $(this).parents('.floating-group').addClass('focused');
        })
    });
});

$('.look-into').on('click', () => {
    $(".zoomImage").toggleClass("d-none");
    $(".zoomOut").toggleClass("dontShow");
    $('.nav-link').removeClass('active');
    $('.tab-pane').removeClass('active show');
})

$('.close-icon').on('click', () => {
    $(".zoomImage").toggleClass("d-none");
    $(".zoomOut").toggleClass("dontShow");
})

$(document).on('click', '.show-mega-area', function () {
    let type = $(this).data('type');

    if (type === 'photo') {
        $('.sliderFive').slick('refresh')
    }

    $('#' + type + '-tab').addClass('active');
    $('#' + type).addClass('active show');
})


$('.mobile-search-toggle-icon').on('click', function () {
    $('.mobile-search-icon, .mobile-search-area').toggleClass('d-none');
})
