<?php namespace Visiosoft\HepsiemlakTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\TypeRepository;
use Anomaly\NavigationModule\Link\LinkRepository;
use Anomaly\NavigationModule\Menu\MenuRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\DopingsModule\Type\TypeRepository as DopingTypeRepository;

class HepsiemlakThemeSeeder extends Seeder
{
    protected $areaRepository;
    protected $typeRepository;
    protected $fields;
    protected $streamRepository;
    protected $assignments;
    protected $dopingsType;
    protected $menuRepository;
    protected $linkRepository;


    public function __construct(
        AreaRepository $areaRepository,
        TypeRepository $typeRepository,
        FieldRepositoryInterface $fields,
        StreamRepositoryInterface $streamRepository,
        AssignmentRepositoryInterface $assignments,
        DopingTypeRepository $dopingsType,
        MenuRepository $menuRepository,
        LinkRepository $linkRepository
    )
    {
        $this->areaRepository = $areaRepository;
        $this->typeRepository = $typeRepository;
        $this->fields = $fields;
        $this->streamRepository = $streamRepository;
        $this->assignments = $assignments;
        $this->dopingsType = $dopingsType;
        $this->menuRepository = $menuRepository;
        $this->linkRepository = $linkRepository;
    }

    public function run()
    {
        // Blocks
        $areas = [
            [
                'en' => [
                    'name' => 'Homepage Banners',
                ],
                'slug' => 'homepage-banners',
            ]
        ];

        foreach ($areas as $area) {
            if (!$this->areaRepository->findBySlug($area['slug'])) {
                $this->areaRepository->create($area);
            }
        }

        $types = [
            [
                'name' => 'Homepage Banners',
                'slug' => 'homepage_banners',
            ]
        ];

        foreach ($types as $type) {
            $exist_type = $this->typeRepository->findBySlug($type['slug']);
            if (!$exist_type) {
                $this->typeRepository->create([
                    'slug' => $type['slug'],
                    'name' => $type['name'],
                    'category' => 'other',
                ]);
            }
        }

        $blockFields = [
            [
                'name' => 'Editor',
                'slug' => 'editor',
                'namespace' => 'blocks',
                'streams' => ['homepage_banners'],
                'type' => 'anomaly.field_type.editor',
                'translatable' => true,
                'config' => [],
            ], [
                'name' => 'Image',
                'slug' => 'image',
                'namespace' => 'blocks',
                'streams' => ['homepage_banners'],
                'type' => 'anomaly.field_type.file',
                'translatable' => true,
                'config' => [
                    'folders' => ['images'],
                    'mode' => 'upload',
                ],
            ]
        ];

        foreach ($blockFields as $blockField) {
            $field = $this->fields->findBySlugAndNamespace($blockField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fields->create([
                    'name' => $blockField['name'],
                    'slug' => $blockField['slug'],
                    'namespace' => $blockField['namespace'],
                    'type' => $blockField['type'],
                    'locked' => 0,
                    'config' => $blockField['config'],
                ]);
            }

            foreach ($blockField['streams'] as $stream) {
                $typeStream = $this->streamRepository->findBySlugAndNamespace($stream. '_blocks', 'blocks');

                if ($typeStream && !$this->assignments->findByStreamAndField($typeStream, $field)) {
                    $this->assignments->create([
                        'stream_id' => $typeStream->getId(),
                        'field_id' => $field->getId(),
                        'translatable' => $blockField['translatable'],
                    ]);
                }
            }
        }


        // Dopings
        if (is_module_installed('visiosoft.module.dopings')){
            $dopings = [
                [
                    'slug' => 'investment',
                    'en' => [
                        'name' => 'Investment',
                    ],
                    'tr' => [
                        'name' => 'Yatırımlık',
                    ]
                ],[
                    'slug' => 'new_project',
                    'en' => [
                        'name' => 'New Project',
                    ],
                    'tr' => [
                        'name' => 'Yeni Proje',
                    ]
                ]
            ];

            foreach ($dopings as $doping) {
                if (!$this->dopingsType->findBySlug($doping['slug'])) {
                    $this->dopingsType->create($doping);
                }
            }
        }

        // Navigations
        if (!$footerTabs = $this->menuRepository->findBySlug('footer_tabs_area')){
            $footerTabs = $this->menuRepository->create([
                'slug' => 'footer_tabs_area',
                'en' => [
                    'name' => 'Footer tab area',
                ],
            ]);
        }
    }
}
