<?php

return [
    "logo" => "anomaly.field_type.file",
    "logo_white" => "anomaly.field_type.file",
    "mobile_logo" => "anomaly.field_type.file",
    "home_background_image" => "anomaly.field_type.file",
    "categories" => [
        "type" => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "options" => static function (\Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->getMainCategories()->pluck('name', 'id')->all();
            },
        ]
    ],
    "popular_cities" => [
        "type" => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "options" => static function (\Visiosoft\LocationModule\City\CityModel $cityModel) {
                return $cityModel->all()->pluck('name', 'id')->all();
            },
        ]
    ],
    "facebook_address" => "anomaly.field_type.url",
    "instagram_address" => "anomaly.field_type.url",
    "twitter_address" => "anomaly.field_type.url",
    "linkedin_address" => "anomaly.field_type.url",
    "youtube_address" => "anomaly.field_type.url",
    "app_store" => "anomaly.field_type.url",
    "android_store" => "anomaly.field_type.url",
    "qr" => "anomaly.field_type.file",
    "footer_logo" => "anomaly.field_type.file",
    'free_post_message' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'Bireysel Üyeler 3 adete kadar ücretsiz ilan verebilir'
        ]
    ],
    'warning_message' => [
        'type' => 'anomaly.field_type.textarea',
        "config" => [
            "default_value" => "The ad creator is solely responsible for the content, correctness, accuracy and legal obligation of all posted ads, entries, ideas and information. openclassify.com is not in any way responsible for the quality or legality of content created and posted by its users. You should contact the ad creator directly with your questions.",
        ]
    ],
    'list_cats' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'mode' => 'tags',
            'options' => function () {
                return app(\Anomaly\PostsModule\Category\CategoryModel::class)->get()->pluck('name', 'id');
            }
        ]
    ]
];
