<?php namespace Visiosoft\HepsiemlakTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\TypeRepository;
use Anomaly\FilesModule\Folder\Contract\FolderRepositoryInterface;
use Anomaly\NavigationModule\Link\LinkRepository;
use Anomaly\NavigationModule\Menu\MenuRepository;
use Anomaly\PostsModule\Category\Contract\CategoryRepositoryInterface;
use Anomaly\PostsModule\Post\Contract\PostRepositoryInterface;
use Anomaly\PostsModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\PostsModule\Type\TypeRepository as PostTypeRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Posts\PostsDefaultPostsEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Illuminate\Http\UploadedFile;
use Intervention\Image\Facades\Image;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\DopingsModule\Type\TypeRepository as DopingTypeRepository;
use Visiosoft\LocationModule\City\CityModel;

class HepsiemlakThemeSeeder extends Seeder
{
    protected $areaRepository;
    protected $typeRepository;
    protected $fields;
    protected $streamRepository;
    protected $assignments;
    protected $menuRepository;
    protected $linkRepository;
    protected $postType;
    protected $postsRepository;
    protected $types;
    protected $categories;
    protected $advRepository;

    public function __construct(
        AreaRepository                $areaRepository,
        TypeRepository                $typeRepository,
        FieldRepositoryInterface      $fields,
        StreamRepositoryInterface     $streamRepository,
        AssignmentRepositoryInterface $assignments,
        MenuRepository                $menuRepository,
        LinkRepository                $linkRepository,
        PostTypeRepository            $postType,
        PostRepositoryInterface       $postsRepository,
        TypeRepositoryInterface       $types,
        CategoryRepositoryInterface   $categories,
        AdvRepositoryInterface        $advRepository
    )
    {
        $this->areaRepository = $areaRepository;
        $this->typeRepository = $typeRepository;
        $this->fields = $fields;
        $this->streamRepository = $streamRepository;
        $this->assignments = $assignments;
        $this->menuRepository = $menuRepository;
        $this->linkRepository = $linkRepository;
        $this->postType = $postType;
        $this->postsRepository      = $postsRepository;
        $this->types      = $types;
        $this->categories = $categories;
        $this->advRepository = $advRepository;
    }

    public function run()
    {
        // Blocks
        $areas = [
            [
                'en' => [
                    'name' => 'Homepage Banners',
                ],
                'slug' => 'homepage-banners',
            ],
            [
                'en' => [
                    'name' => 'Cities',
                ],
                'slug' => 'cities',
            ],
            [
                'en' => [
                    'name' => 'Popular Search',
                ],
                'slug' => 'popular_search',
            ]
        ];

        foreach ($areas as $area) {
            if (!$this->areaRepository->findBySlug($area['slug'])) {
                $this->areaRepository->create($area);
            }
        }

        $types = [
            [
                'name' => 'Homepage Banners',
                'slug' => 'homepage_banners',
            ],
            [
                'name' => 'Cities',
                'slug' => 'cities',
            ],
            [
                'name' => 'Popular Search',
                'slug' => 'popular_search',
            ]
        ];

        foreach ($types as $type) {
            $exist_type = $this->typeRepository->findBySlug($type['slug']);
            if (!$exist_type) {
                $this->typeRepository->create([
                    'slug' => $type['slug'],
                    'name' => $type['name'],
                    'category' => 'other',
                ]);
            }
        }

        $blockFields = [
            [
                'name' => 'Editor',
                'slug' => 'editor',
                'namespace' => 'blocks',
                'streams' => ['homepage_banners'],
                'type' => 'anomaly.field_type.editor',
                'translatable' => true,
                'config' => [],
            ], [
                'name' => 'Image',
                'slug' => 'image',
                'namespace' => 'blocks',
                'streams' => ['homepage_banners', 'cities'],
                'type' => 'anomaly.field_type.file',
                'translatable' => true,
                'config' => [
                    'folders' => ['banner_images'],
                    'mode' => 'upload',
                ],
            ], [
                'name' => 'City',
                'slug' => 'city',
                'namespace' => 'blocks',
                'streams' => ['cities'],
                'type' => 'anomaly.field_type.relationship',
                'translatable' => false,
                'config' => [
                    'related' => CityModel::class,
                    "default_value" => 0,
                ],
            ], [
                'name' => 'URL',
                'slug' => 'url',
                'namespace' => 'blocks',
                'streams' => ['cities', 'popular_search'],
                'type' => 'anomaly.field_type.url',
                'translatable' => false,
                'config' => []
            ], [
                'name' => 'Search',
                'slug' => 'search',
                'namespace' => 'blocks',
                'streams' => ['popular_search'],
                'translatable' => false,
                'type' => 'anomaly.field_type.text',
                'config' => [],
            ]
        ];

        foreach ($blockFields as $blockField) {
            $field = $this->fields->findBySlugAndNamespace($blockField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fields->create([
                    'name' => $blockField['name'],
                    'slug' => $blockField['slug'],
                    'namespace' => $blockField['namespace'],
                    'type' => $blockField['type'],
                    'locked' => 0,
                    'config' => $blockField['config'],
                ]);
            }

            foreach ($blockField['streams'] as $stream) {
                $typeStream = $this->streamRepository->findBySlugAndNamespace($stream . '_blocks', 'blocks');

                if ($typeStream && !$this->assignments->findByStreamAndField($typeStream, $field)) {
                    $this->assignments->create([
                        'stream_id' => $typeStream->getId(),
                        'field_id' => $field->getId(),
                        'translatable' => $blockField['translatable'],
                    ]);
                }
            }
        }


        // Dopings
        if (is_module_installed('visiosoft.module.dopings')) {
            $dopingsType = app(DopingTypeRepository::class);

            $dopings = [
                [
                    'slug' => 'investment',
                    'en' => [
                        'name' => 'Investment',
                    ],
                    'tr' => [
                        'name' => 'Yatırımlık',
                    ]
                ], [
                    'slug' => 'new_project',
                    'en' => [
                        'name' => 'New Project',
                    ],
                    'tr' => [
                        'name' => 'Yeni Proje',
                    ]
                ]
            ];

            foreach ($dopings as $doping) {
                if (!$dopingsType->findBySlug($doping['slug'])) {
                    $dopingsType->create($doping);
                }
            }
        }

        // Navigations
        if (!$footerTabs = $this->menuRepository->findBySlug('footer_tabs_area')) {
            $footerTabs = $this->menuRepository->create([
                'slug' => 'footer_tabs_area',
                'en' => [
                    'name' => 'Footer tab area',
                ],
            ]);
        }

        // Post Fields
        if (!$field = $this->fields->findBySlugAndNamespace('image', 'posts')) {
            $field = $this->fields->create([
                'name' => 'Image',
                'namespace' => 'posts',
                'slug' => 'image',
                'type' => 'anomaly.field_type.file',
                'config' => [
                    'folders' => ['images'],
                ],
                'locked' => 0
            ]);
        }

        if ($type = $this->postType->findBySlug('default')) {
            $stream = $type->getEntryStream();
            if (!$this->assignments->findByStreamAndField($stream, $field)) {
                $this->assignments->create([
                    'translatable' => false,
                    'stream' => $stream,
                    'field' => $field,
                ]);
            }
        }

        // Post
        $repository = new EntryRepository();
        $repository->setModel(new PostsDefaultPostsEntryModel());
        $type     = $this->types->findBySlug('default');
        $category = $this->categories->findBySlug('news');

        $posts = [
          [
              'title' => 'İpotekli Evimi Nasıl Satarım?',
              'desc' => 'Yasal olarak borç verme hakkına sahip bankalar veya alacaklı durumdaki kişiler, alacaklarını tahsil etmek adına kimi yollar izlemektedirler ipotekli ev de bunlardan biridir. İpotek yöntemi bu yolların başında gelmektedir. Peki ipotek nedir? İpotek, ‘bir taşınmazın alacağa karşılık güvence olarak tutulması’ anlamına gelmektedir. Yani ödenmesi beklenen borcun karşılığında taşınmazların üzerine konulan şerhtir. Borçlu kişinin yükümlülüğünü yerine getirmemesi halinde, alacaklı taraf taşınmazı satılığa çıkarma yöntemiyle alacağını tahsil edebilme hakkına sahip olabilmektedir. Bu tanımlamadan sonra akla gelen bir diğer soru ipotekli ev satışı için nasıl yollar izlenebileceğidir. Öncelikle bu prosedürün en baştan nasıl işlediği hakkında bilgi vermekte fayda var.  Kredi çekerek ev sahibi olmayı amaçlayan alıcılar, bankalar aracılığıyla konut kredisine başvurabilmektedir. Bu süreçte banka, kredi borcu ödenene kadar mevzubahis evi ipotek eder. Tanımda da bahsedildiği gibi borcun tahsil edilmediği durumda ise bu evi satma hakkına sahip olur. Borç ödendiği zaman da bu ipotek kaldırılır ve kredisini çeken kişi evin sahibi olmuş olur. Peki konut kredisini çeken kişi evini satmak isterse ne gibi bir yol izlemelidir? İpotekli ev nasıl satılır? Bu tarz bir satış iki şekilde gerçekleşebilmektedir.',
              'filename' => '1.jpg',
          ],
          [
              'title' => 'Hayata Açılan Renkli Kapı: Büyükyalı',
              'desc' => 'Yasal olarak borç verme hakkına sahip bankalar veya alacaklı durumdaki kişiler, alacaklarını tahsil etmek adına kimi yollar izlemektedirler ipotekli ev de bunlardan biridir. İpotek yöntemi bu yolların başında gelmektedir. Peki ipotek nedir? İpotek, ‘bir taşınmazın alacağa karşılık güvence olarak tutulması’ anlamına gelmektedir. Yani ödenmesi beklenen borcun karşılığında taşınmazların üzerine konulan şerhtir. Borçlu kişinin yükümlülüğünü yerine getirmemesi halinde, alacaklı taraf taşınmazı satılığa çıkarma yöntemiyle alacağını tahsil edebilme hakkına sahip olabilmektedir. Bu tanımlamadan sonra akla gelen bir diğer soru ipotekli ev satışı için nasıl yollar izlenebileceğidir. Öncelikle bu prosedürün en baştan nasıl işlediği hakkında bilgi vermekte fayda var.  Kredi çekerek ev sahibi olmayı amaçlayan alıcılar, bankalar aracılığıyla konut kredisine başvurabilmektedir. Bu süreçte banka, kredi borcu ödenene kadar mevzubahis evi ipotek eder. Tanımda da bahsedildiği gibi borcun tahsil edilmediği durumda ise bu evi satma hakkına sahip olur. Borç ödendiği zaman da bu ipotek kaldırılır ve kredisini çeken kişi evin sahibi olmuş olur. Peki konut kredisini çeken kişi evini satmak isterse ne gibi bir yol izlemelidir? İpotekli ev nasıl satılır? Bu tarz bir satış iki şekilde gerçekleşebilmektedir.',
              'filename' => '2.jpg',
          ],
          [
              'title' => 'İş Ortağımız Evergreen ile Kıbrıs Emlak Piyasasını Konuştuk',
              'desc' => 'Yasal olarak borç verme hakkına sahip bankalar veya alacaklı durumdaki kişiler, alacaklarını tahsil etmek adına kimi yollar izlemektedirler ipotekli ev de bunlardan biridir. İpotek yöntemi bu yolların başında gelmektedir. Peki ipotek nedir? İpotek, ‘bir taşınmazın alacağa karşılık güvence olarak tutulması’ anlamına gelmektedir. Yani ödenmesi beklenen borcun karşılığında taşınmazların üzerine konulan şerhtir. Borçlu kişinin yükümlülüğünü yerine getirmemesi halinde, alacaklı taraf taşınmazı satılığa çıkarma yöntemiyle alacağını tahsil edebilme hakkına sahip olabilmektedir. Bu tanımlamadan sonra akla gelen bir diğer soru ipotekli ev satışı için nasıl yollar izlenebileceğidir. Öncelikle bu prosedürün en baştan nasıl işlediği hakkında bilgi vermekte fayda var.  Kredi çekerek ev sahibi olmayı amaçlayan alıcılar, bankalar aracılığıyla konut kredisine başvurabilmektedir. Bu süreçte banka, kredi borcu ödenene kadar mevzubahis evi ipotek eder. Tanımda da bahsedildiği gibi borcun tahsil edilmediği durumda ise bu evi satma hakkına sahip olur. Borç ödendiği zaman da bu ipotek kaldırılır ve kredisini çeken kişi evin sahibi olmuş olur. Peki konut kredisini çeken kişi evini satmak isterse ne gibi bir yol izlemelidir? İpotekli ev nasıl satılır? Bu tarz bir satış iki şekilde gerçekleşebilmektedir.',
              'filename' => '3.jpg',
          ],
          [
              'title' => 'Yaşam Alanınızı Ferah Gösterecek Öneriler',
              'desc' => 'Yasal olarak borç verme hakkına sahip bankalar veya alacaklı durumdaki kişiler, alacaklarını tahsil etmek adına kimi yollar izlemektedirler ipotekli ev de bunlardan biridir. İpotek yöntemi bu yolların başında gelmektedir. Peki ipotek nedir? İpotek, ‘bir taşınmazın alacağa karşılık güvence olarak tutulması’ anlamına gelmektedir. Yani ödenmesi beklenen borcun karşılığında taşınmazların üzerine konulan şerhtir. Borçlu kişinin yükümlülüğünü yerine getirmemesi halinde, alacaklı taraf taşınmazı satılığa çıkarma yöntemiyle alacağını tahsil edebilme hakkına sahip olabilmektedir. Bu tanımlamadan sonra akla gelen bir diğer soru ipotekli ev satışı için nasıl yollar izlenebileceğidir. Öncelikle bu prosedürün en baştan nasıl işlediği hakkında bilgi vermekte fayda var.  Kredi çekerek ev sahibi olmayı amaçlayan alıcılar, bankalar aracılığıyla konut kredisine başvurabilmektedir. Bu süreçte banka, kredi borcu ödenene kadar mevzubahis evi ipotek eder. Tanımda da bahsedildiği gibi borcun tahsil edilmediği durumda ise bu evi satma hakkına sahip olur. Borç ödendiği zaman da bu ipotek kaldırılır ve kredisini çeken kişi evin sahibi olmuş olur. Peki konut kredisini çeken kişi evini satmak isterse ne gibi bir yol izlemelidir? İpotekli ev nasıl satılır? Bu tarz bir satış iki şekilde gerçekleşebilmektedir.',
              'filename' => '4.jpg',
          ],
        ];

        foreach ($posts as $post) {

            $entry = (new PostsDefaultPostsEntryModel())->create(
                [
                    'en' => [
                        'content' => $post['desc'],
                    ],
                    'image_id' => $this->setFile($post['filename']),
                ]
            );

            $this->postsRepository->create(
                [
                    'en'         => [
                        'title'   => $post['title'],
                        'summary' => 'This is an example post to demonstrate the posts module.',
                    ],
                    'slug'       => str_slug($post['title']),
                    'publish_at' => time(),
                    'enabled'    => true,
                    'type'       => $type,
                    'entry'      => $entry,
                    'category'   => $category,
                    'author'     => 1,
                ]
            );
        }


        $advs = [
            [
                'en' => [
                    'name' => 'OSTİM LÜKS YAPILI 2 ADET BİTİŞİK AYRI PARSEL FABRİKA',
                ],
                'slug' => 'ostim',
                'price' => 9830,
                'currency' => 'USD',
                'country_id' => 212,
                'city' => 26,
                'status' => 'approved',
                'cat1' => 3613,
                'publish_at' => now(),
                'finish_at' => '2025-12-10 13:01:22.000000',
            ],
            [
                'en' => [
                    'name' => 'KAMPANYA 1+0 140 tl 1+1 jakuzuli 200 tl PAŞA KONAĞI',
                ],
                'slug' => 'kampanya',
                'price' => 4650,
                'currency' => 'USD',
                'country_id' => 212,
                'city' => 26,
                'status' => 'approved',
                'cat1' => 3613,
                'publish_at' => now(),
                'finish_at' => '2025-12-10 13:01:22.000000',
            ],
            [
                'en' => [
                    'name' => 'BORSEM DİKMEN\'DEN Ç.EMEÇ ÖSYM YAKINI SİTEDE PARK MANZARALI 4+1+KİLER',
                ],
                'slug' => 'borsem',
                'price' => 2138,
                'currency' => 'USD',
                'country_id' => 212,
                'city' => 26,
                'status' => 'approved',
                'cat1' => 3613,
                'publish_at' => now(),
                'finish_at' => '2025-12-10 13:01:22.000000',
            ],
            [
                'en' => [
                    'name' => 'SÖĞÜTÖZÜ VIA TWINS PLAZA YÜKSEK KAT MANZARALI KULLANIŞLI 84 M2 OFİS FIRSATI',
                ],
                'slug' => 'sogutozu',
                'price' => 3000,
                'currency' => 'USD',
                'country_id' => 212,
                'city' => 26,
                'status' => 'approved',
                'cat1' => 3613,
                'publish_at' => now(),
                'finish_at' => '2025-12-10 13:01:22.000000',
            ],
        ];

        foreach ($advs as $key => $adv) {

            $filename = 'restate'. ($key + 1) . '.jpg';
            $this->setFile($filename);
            $adv['cover_photo']  = 'files/images/' . $filename;
            $this->advRepository->create($adv)->getId();
        }
    }

    public function setFile($filename){
        $uploader = app(FileUploader::class);

        $file_path = __DIR__ . '/seed/img/' . $filename;
        $image = Image::make($file_path);

        $file = new UploadedFile($file_path,
            $image->basename,
            $image->mime);

        $folders = app(FolderRepositoryInterface::class);
        if (($folder = $folders->findBySlug('images')) && $file = $uploader->upload($file, $folder)) {
            return $file->id;
        }
    }
}
