<?php namespace Visiosoft\HepsiemlakTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\BlocksModule\Type\TypeRepository;
use Anomaly\NavigationModule\Link\LinkRepository;
use Anomaly\NavigationModule\Menu\MenuRepository;
use Anomaly\PostsModule\Type\TypeRepository as PostTypeRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\DopingsModule\Type\TypeRepository as DopingTypeRepository;

class HepsiemlakThemeSeeder extends Seeder
{
    protected $areaRepository;
    protected $typeRepository;
    protected $fields;
    protected $streamRepository;
    protected $assignments;
    protected $menuRepository;
    protected $linkRepository;
    protected $postType;


    public function __construct(
        AreaRepository                $areaRepository,
        TypeRepository                $typeRepository,
        FieldRepositoryInterface      $fields,
        StreamRepositoryInterface     $streamRepository,
        AssignmentRepositoryInterface $assignments,
        MenuRepository                $menuRepository,
        LinkRepository                $linkRepository,
        PostTypeRepository            $postType
    )
    {
        $this->areaRepository = $areaRepository;
        $this->typeRepository = $typeRepository;
        $this->fields = $fields;
        $this->streamRepository = $streamRepository;
        $this->assignments = $assignments;
        $this->menuRepository = $menuRepository;
        $this->linkRepository = $linkRepository;
        $this->postType = $postType;
    }

    public function run()
    {
        // Blocks
        $areas = [
            [
                'en' => [
                    'name' => 'Homepage Banners',
                ],
                'slug' => 'homepage-banners',
            ]
        ];

        foreach ($areas as $area) {
            if (!$this->areaRepository->findBySlug($area['slug'])) {
                $this->areaRepository->create($area);
            }
        }

        $types = [
            [
                'name' => 'Homepage Banners',
                'slug' => 'homepage_banners',
            ]
        ];

        foreach ($types as $type) {
            $exist_type = $this->typeRepository->findBySlug($type['slug']);
            if (!$exist_type) {
                $this->typeRepository->create([
                    'slug' => $type['slug'],
                    'name' => $type['name'],
                    'category' => 'other',
                ]);
            }
        }

        $blockFields = [
            [
                'name' => 'Editor',
                'slug' => 'editor',
                'namespace' => 'blocks',
                'streams' => ['homepage_banners'],
                'type' => 'anomaly.field_type.editor',
                'translatable' => true,
                'config' => [],
            ], [
                'name' => 'Image',
                'slug' => 'image',
                'namespace' => 'blocks',
                'streams' => ['homepage_banners'],
                'type' => 'anomaly.field_type.file',
                'translatable' => true,
                'config' => [
                    'folders' => ['banner_images'],
                    'mode' => 'upload',
                ],
            ]
        ];

        foreach ($blockFields as $blockField) {
            $field = $this->fields->findBySlugAndNamespace($blockField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fields->create([
                    'name' => $blockField['name'],
                    'slug' => $blockField['slug'],
                    'namespace' => $blockField['namespace'],
                    'type' => $blockField['type'],
                    'locked' => 0,
                    'config' => $blockField['config'],
                ]);
            }

            foreach ($blockField['streams'] as $stream) {
                $typeStream = $this->streamRepository->findBySlugAndNamespace($stream . '_blocks', 'blocks');

                if ($typeStream && !$this->assignments->findByStreamAndField($typeStream, $field)) {
                    $this->assignments->create([
                        'stream_id' => $typeStream->getId(),
                        'field_id' => $field->getId(),
                        'translatable' => $blockField['translatable'],
                    ]);
                }
            }
        }


        // Dopings
        if (is_module_installed('visiosoft.module.dopings')) {
            $dopingsType = app(DopingTypeRepository::class);

            $dopings = [
                [
                    'slug' => 'investment',
                    'en' => [
                        'name' => 'Investment',
                    ],
                    'tr' => [
                        'name' => 'Yatırımlık',
                    ]
                ], [
                    'slug' => 'new_project',
                    'en' => [
                        'name' => 'New Project',
                    ],
                    'tr' => [
                        'name' => 'Yeni Proje',
                    ]
                ]
            ];

            foreach ($dopings as $doping) {
                if (!$dopingsType->findBySlug($doping['slug'])) {
                    $dopingsType->create($doping);
                }
            }
        }

        // Navigations
        if (!$footerTabs = $this->menuRepository->findBySlug('footer_tabs_area')) {
            $footerTabs = $this->menuRepository->create([
                'slug' => 'footer_tabs_area',
                'en' => [
                    'name' => 'Footer tab area',
                ],
            ]);
        }

        // Post Fields
        if (!$field = $this->fields->findBySlugAndNamespace('image', 'posts')) {
            $field = $this->fields->create([
                'name' => 'Image',
                'namespace' => 'posts',
                'slug' => 'image',
                'type' => 'anomaly.field_type.file',
                'config' => [
                    'folders' => ['images'],
                ],
                'locked' => 0
            ]);
        }

        if ($type = $this->postType->findBySlug('default')) {
            $stream = $type->getEntryStream();
            if (!$this->assignments->findByStreamAndField($stream, $field)) {
                $this->assignments->create([
                    'translatable' => false,
                    'stream' => $stream,
                    'field' => $field,
                ]);
            }
        }
    }
}
