<?php

return [
    "logo" => "anomaly.field_type.file",
    "logo_white" => "anomaly.field_type.file",
    "mobile_logo" => "anomaly.field_type.file",
    "categories" => [
        "type" => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "options" => static function (\Visiosoft\CatsModule\Category\Contract\CategoryRepositoryInterface $categoryRepository) {
                return $categoryRepository->getMainCategories()->pluck('name', 'id')->all();
            },
        ]
    ],
    "popular_cities" => [
        "type" => "anomaly.field_type.checkboxes",
        "config" => [
            "mode" => "tags",
            "options" => static function (\Visiosoft\LocationModule\City\CityModel $cityModel) {
                return $cityModel->all()->pluck('name', 'id')->all();
            },
        ]
    ],
    "facebook_address" => "anomaly.field_type.url",
    "instagram_address" => "anomaly.field_type.url",
    "twitter_address" => "anomaly.field_type.url",
    "linkedin_address" => "anomaly.field_type.url",
    "youtube_address" => "anomaly.field_type.url",
    "app_store" => "anomaly.field_type.url",
    "android_store" => "anomaly.field_type.url",
    "qr" => "anomaly.field_type.file",
    "footer_logo" => "anomaly.field_type.file",
    'free_post_message' => [
        'type' => 'anomaly.field_type.text',
        'config' => [
            'default_value' => 'Bireysel Üyeler 3 adete kadar ücretsiz ilan verebilir'
        ]
    ],
    'list_cats' => [
        'type' => 'anomaly.field_type.checkboxes',
        'config' => [
            'mode' => 'tags',
            'options' => function () {
                return app(\Anomaly\PostsModule\Category\CategoryModel::class)->get()->pluck('name', 'id');
            }
        ]
    ]
];
