<?php namespace Visiosoft\HepsiburadaModule\Integratedproduct\Listener;

use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\HepsiburadaModule\Integratedproduct\IntegratedproductRepository;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController;
use Visiosoft\HepsiburadaModule\Integratedproduct\Form\ImportProductFormHandler;
use Anomaly\Streams\Platform\Message\MessageBag;

class UpdateProduct extends ImportProductFormHandler
{
    public function handleUpdate(EditedAd $updatedAdvModel)
    {
        $updatedProduct = $updatedAdvModel->getAdDetail();

        $integratedProducts = app(IntegratedproductRepository::class);

        // Detect whether the updated product is an integrated product.

        if ($integratedProductToBeUpdated = $integratedProducts->findBy('product_id', $updatedProduct->id)) {
            // Yes! Let's update the product on Hepsiburada as well.

            // First we will fetch the merchant listing information for the updated product so that we can use in the update request

            $apiRequestController = new ApiRequestController();
            $listingInformation = $apiRequestController->getListingInformation(
                $apiRequestController->hepsiburada->merchantId, json_decode($integratedProductToBeUpdated->hepsiburada_product_information)->merchantSku);

            // Now we can update listing information

            $productInformation = '
            <?xml version="1.0" encoding="utf-8"?>
            <listings xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema">
                <listing>
                    <HepsiburadaSku>'.$integratedProductToBeUpdated->hepsiburada_sku.'</HepsiburadaSku>
                    <MerchantSku>'.json_decode($integratedProductToBeUpdated->hepsiburada_product_information)->merchantSku.'</MerchantSku>
                    <ProductName>'.$integratedProductToBeUpdated->name.'</ProductName>
                    <Price>'.$integratedProductToBeUpdated->price.'</Price>
                    <AvailableStock>'.$integratedProductToBeUpdated->stock.'</AvailableStock>
                    <DispatchTime>'.$listingInformation->DispatchTime.'</DispatchTime>
                    <CargoCompany1>'.$listingInformation->CargoCompany1.'</CargoCompany1>
                    <CargoCompany2>'.$listingInformation->CargoCompany2.'</CargoCompany2>
                    <CargoCompany3>'.$listingInformation->CargoCompany3.'</CargoCompany3>
                </listing>
            </listings>  
            ';

            $result = $apiRequestController->updateListingInformation(
                $apiRequestController->hepsiburada->merchantId, $productInformation
            );

            $this->messages->success(trans('visiosoft.module.hepsiburada::message.update_request_accepted') . $result->id);
        }
    }
}

