<?php namespace Visiosoft\HepsiburadaModule\Integratedproduct\Form;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Anomaly\FilesModule\File\FileModel;
use Intervention\Image\Facades\Image;
use Visiosoft\HepsiburadaModule\Integratedproduct\IntegratedproductRepository;

class ImportProductFormHandler extends AdminController
{
    public function handle(ImportProductFormBuilder $builder, MessageBag $messages, AdvModel $advModel)
    {       
        $advs = app(AdvRepositoryInterface::class);

        $advToBeIntegrated = $advs->find($builder->getFormEntry());

        $attributesSetForHb = json_decode( $builder->getFormValue('allCategoryAttributes') );

        // convert product images array into a format that can be sent to Hepsiburada

        $imagesArrToBeSentToHepsiburada = array();

        $productImagesArr = $advModel->getAdvimage($builder->getFormEntry());

        foreach ($productImagesArr as $image) {
            array_push($imagesArrToBeSentToHepsiburada, (object)array(
                "url" => $image->make()->url()
            ));
        }        

        if ($advToBeIntegrated->currency !== 'TRY') {
            $this->changeCurrency($advToBeIntegrated);
        }        

        preg_match_all("/\d+/", $builder->getFormValue('category'), $categoryInputMatches);

        $productInformation = [
            [
                "categoryId" => intval($categoryInputMatches[0][0]),
                "merchant" => $builder->getFormValue('merchant_id'),
                "attributes" => [
                  "VaryantGroupID" => "Hepsiburada0",
                  "UrunAdi" => $advToBeIntegrated->name,
                  "UrunAciklamasi" => $advToBeIntegrated->advs_desc,
                //   "Image1" => $imagesArrToBeSentToHepsiburada[0] ? $imagesArrToBeSentToHepsiburada[0]->url : '',
                  "Image1" => 'https://www.aktuelexpress.com/content/images/thumbs/0001062_uni-ball-sg-100-tukenmez-kalem-14-mm-mavi_350.webp',
                  "Image2" => array_key_exists(1, $imagesArrToBeSentToHepsiburada) ? $imagesArrToBeSentToHepsiburada[1]->url : '',
                  "Image3" => array_key_exists(2, $imagesArrToBeSentToHepsiburada) ? $imagesArrToBeSentToHepsiburada[2]->url : '',
                  "Image4" => array_key_exists(3, $imagesArrToBeSentToHepsiburada) ? $imagesArrToBeSentToHepsiburada[3]->url : '',
                  "Image5" => array_key_exists(4, $imagesArrToBeSentToHepsiburada) ? $imagesArrToBeSentToHepsiburada[4]->url : '',
                  "price" => $advToBeIntegrated->price,
                  "stock" => $advToBeIntegrated->stock,
                ]                
            ]
        ];

        foreach ($attributesSetForHb as $attribute) {
            $productInformation[0]['attributes'][$attribute->id] = $attribute->value;
        }

        $apiRequestController = new ApiRequestController();

        // we will import the product

        $response = $apiRequestController->importProduct($productInformation, true, true);

        if ($response->success) {
            $this->saveIntegration($advToBeIntegrated, $productInformation, $response->data->trackingId);
            $messages->success(trans('visiosoft.module.hepsiburada::message.success_integration'));
        } else {
            $messages->error($response->message);
        }
    }

    public function changeCurrency($productCreatedOnOurSite)
    {
        $settings = app(\Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface::class);
        $productCreatedOnOurSite->foreignCurrency($productCreatedOnOurSite->currency, $productCreatedOnOurSite->price, 
        $productCreatedOnOurSite->id, $settings, false);
        $currencyList = (array)(json_decode($productCreatedOnOurSite->foreign_currencies));
        $productCreatedOnOurSite->price = $currencyList["TRY"];
    }

    public function saveIntegration($advToBeIntegrated, $productInformation, $trackingId)
    {
        $integratedProducts = app(IntegratedproductRepository::class);

        $integratedProduct = $integratedProducts->create([
            'product_id' => $advToBeIntegrated->id,
            'hepsiburada_sku' => null,
            'tracking_id' => $trackingId,
            'hepsiburada_product_information' => json_encode($productInformation[0]['attributes']),
        ]);        
    }
}
