<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin\Services;

use Visiosoft\HepsiburadaModule\Http\Controller\Admin\Services\ProductService;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\Helper\Request;

Class ListingService extends ProductService
{
	// Base API Url Adress

	public $apiUrl = 'https://listing-external-sit.hepsiburada.com/listings/merchantid/';

	// Making the necessary settings for the Request class

	public function __construct($merchantId, $username, $password, $testmode)
	{
		Request::__construct($merchantId, $username, $password, $testmode);
	}

    // Fetches listing information of merchant
    public function getListingInformation($merchantId, $merchantSkuList)
    {
        if (is_array($merchantSkuList)) {
            $str = implode(",", $merchantSkuList);
        } else {
            $str = $merchantSkuList;
        }
        $this->setApiUrl($this->apiUrl . $merchantId . '?merchantskulist=' . $str);

        return $this->getResponse();
    }

    public function updateListingInformation($merchantId, $productInformation)
    {
        $this->setApiUrl($this->apiUrl . $merchantId . '/inventory-uploads');
        $this->setMethod("POST");

        return $this->getResponse($productInformation);
    }

    public function deleteListing($merchantId, $hbsku, $merchantsku)
    {
        $this->setApiUrl($this->apiUrl . $merchantId . '/sku' . $hbsku . '/merchantsku' . $merchantsku);
        $this->setMethod("DELETE");

        return $this->getResponse();
    }
}