<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\HepsiburadaClient;
use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;

class ApiRequestController extends AdminController
{
    public $hepsiburada;

    public function __construct()
    {
        $hepsiburada = new HepsiburadaClient(); 
        $hepsiburada->setMerchantId(config('hepsiburada.merchant_id'));
        $hepsiburada->setUsername(config('hepsiburada.api_username'));
        $hepsiburada->setPassword(config('hepsiburada.api_password'));
        $hepsiburada->setTestMode(config('hepsiburada.test_environment'));
        $this->hepsiburada = $hepsiburada;
    }

    // Katalog Ürün Entegrasyonu

    public function getCategories($leaf, $status, $available, $page, $size, $version)
    {
        $categories = $this->hepsiburada->product->getCategories($leaf, $status, $available, $page, $size, $version);
        return $categories;
    }

    public function fastListProduct($productInformation)
    {
        $this->hepsiburada->product->fastListProduct($productInformation);
    }

    public function importProduct($productInformation, $authorization, $willFilePosted)
    {
        $response = $this->hepsiburada->product->importProduct($productInformation, $authorization, $willFilePosted);
        return $response;
    }

    public function fetchProductInformationBasedOnStatus($page, $size, $version, $merchantId, $productStatus, $taskStatus)
    {
        $preMatchedProducts = $this->hepsiburada->product->fetchProductInformationBasedOnStatus($page, $size, $version, $merchantId, $productStatus, $taskStatus);
        return $preMatchedProducts;
    }

    public function queryProductStatus($trackingId, $page, $size, $version)
    {
        $productStatus = $this->hepsiburada->product->queryProductStatus($trackingId, $page, $size, $version);

        if ($productStatus->success) {
            return $productStatus;
        }      
    }

    public function getCategoryAttributes($categoryId)
	{
        $categoryAttributes = $this->hepsiburada->product->getCategoryAttributes($categoryId);
        return $categoryAttributes;
	}

    public function getAttributeValues($categoryId, $attributeId, $page, $size, $version)
	{
        $attributeValues = $this->hepsiburada->product->getAttributeValues($categoryId, $attributeId, $page, $size, $version);
        return $attributeValues;
	}

    // Listeleme Entegrasyonu

    public function getListingInformation($merchantId, $merchantSkuList)
    {
        $listingInformation = $this->hepsiburada->listing->getListingInformation($merchantId, $merchantSkuList);
        return $listingInformation;
    }

    public function updateListingInformation($merchantId, $productInformation)
    {
        $result = $this->hepsiburada->listing->updateListingInformation($merchantId, $productInformation);
        return $result;
    }    

    public function deleteListing($merchantId, $hbsku, $merchantsku)
    {
        $result = $this->hepsiburada->listing->deleteListing($merchantId, $hbsku, $merchantsku);
        return $result;        
    }

    // Sipariş Entegrasyonu

    public function getPaidOrders($merchantId, $offset, $limit, $beginDate, $endDate)
    {
        $result = $this->hepsiburada->order->getPaidOrders($merchantId, $offset, $limit, $beginDate, $endDate);
        return $result;
    }
}