<?php namespace Visiosoft\HepsiburadaModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\HepsiburadaModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\HepsiburadaModule\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\Hepsiburada\HepsiburadaOrdersEntryModel;
use Visiosoft\HepsiburadaModule\Order\OrderModel;
use Visiosoft\HepsiburadaModule\Integratedproduct\Contract\IntegratedproductRepositoryInterface;
use Visiosoft\HepsiburadaModule\Integratedproduct\IntegratedproductRepository;
use Anomaly\Streams\Platform\Model\Hepsiburada\HepsiburadaIntegratedproductsEntryModel;
use Visiosoft\HepsiburadaModule\Integratedproduct\IntegratedproductModel;
use Illuminate\Routing\Router;
use Visiosoft\AdvsModule\Adv\Event\EditedAd;
use Visiosoft\AdvsModule\Adv\Event\DeletedAd;

class HepsiburadaModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/hepsiburada/orders'           => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\OrdersController@index',
        'admin/hepsiburada/orders/create'    => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\OrdersController@create',
        'admin/hepsiburada/orders/edit/{id}' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\OrdersController@edit',
        'admin/hepsiburada'           => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\IntegratedproductsController@index',
        'admin/hepsiburada/create'    => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\IntegratedproductsController@create',
        'admin/hepsiburada/edit/{id}' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\IntegratedproductsController@edit',
        'admin/hepsiburada/select-product-to-be-integrated' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\IntegratedproductsController@select',
        'admin/hepsiburada/send-product-exists-in-catalog/{id}' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\IntegratedproductsController@fastListProduct',
        'admin/hepsiburada/send-product-not-exists-in-catalog/{id}' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\IntegratedproductsController@importProduct',
        'admin/hepsiburada/get-categories/{leaf}/{status}/{available}/{page}/{size}/{version}' => 
        'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController@getCategories',
        'admin/hepsiburada/fast-list-product/{product_information}' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController@fastListProduct',
        'admin/hepsiburada/fetch-pre-matched-products' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestHelper@fetchPreMatchedProducts',
        'admin/hepsiburada/query-product-status/{tracking_id}/{page}/{size}/{version}' => 
        'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestHelper@showStatusReport',
        'admin/hepsiburada/get-category-attributes/{category_id}' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController@getCategoryAttributes',
        'admin/hepsiburada/get-attribute-values/{category_id}/{attribute_id}/{page}/{size}/{version}' => 
        'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController@getAttributeValues',
        //cron
        'admin/cron/hepsiburada/pullOrders' => 'Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestHelper@pullOrders',
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\HepsiburadaModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\HepsiburadaModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        EditedAd::class => [
            '\Visiosoft\HepsiburadaModule\Integratedproduct\Listener\UpdateProduct@handleUpdate',
        ],
        DeletedAd::class => [
            '\Visiosoft\HepsiburadaModule\Integratedproduct\Listener\DeleteProduct@handleDelete',
        ],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\HepsiburadaModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        HepsiburadaOrdersEntryModel::class => OrderModel::class,
        HepsiburadaIntegratedproductsEntryModel::class => IntegratedproductModel::class,
        'apply_for_saling_product' => \Visiosoft\HepsiburadaModule\Integratedproduct\Form\ApplyForSalingProductFormBuilder::class,
        'import_product' => \Visiosoft\HepsiburadaModule\Integratedproduct\Form\ImportProductFormBuilder::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        OrderRepositoryInterface::class => OrderRepository::class,
        IntegratedproductRepositoryInterface::class => IntegratedproductRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
