$(document).ready(function(){
    let categoryAttributesModal = document.createElement("div");
    categoryAttributesModal.innerHTML = `
    <div class="modal" data-backdrop="static" data-keyboard="false" id="categoryAttributesModal" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header" style='padding-bottom:0px;'>
                    <h5 class="modal-title text-center">Category Attributes</h5>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="alert alert-info" role="alert">
                        In order for your product to be created in Hepsiburada, at least the required category attribute fields must be filled in.
                    </div>
                    <form name="category_attributes">
                        <div class="form-group container">
                            <div class="row" id="category_attributes_row">

                            </div>
                        </div>
                    </form>
                    </div>
                <div class="modal-footer">
                    <button type="submit" id="save_category_attributes" class="btn btn-primary">Save</button>
                    <a data-toggle="modal" href="#sureToClose" class="btn btn-primary">Close</a>
                </div>
            </div>
        </div>
    </div>`;

    let sureToCloseModal = document.createElement('div');
    sureToCloseModal.innerHTML = `
        <div class="modal" id="sureToClose" tabindex="-1" role="dialog">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Warning</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <p>Are you sure you want to exit without saving required form fields</p>
                    </div>
                    <div class="modal-footer">
                        <button type="button" id="closeModals" class="btn btn-primary">Yes</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">No</button>
                    </div>
                </div>
            </div>
        </div>
    `;

    $("body").append(categoryAttributesModal);
    $("body").append(sureToCloseModal);

    document.getElementById('closeModals').onclick = function() {
        $('#sureToClose').modal('hide');
        $('#categoryAttributesModal').modal('hide');
        document.getElementsByName('categoryAttributes')[0].value = '';
    }

    $('#categoryAttributesModal').on('hidden.bs.modal', function (e) {
        document.getElementById('category_attributes_row').innerHTML = '';
    });

    let pickedAttributes = [];           

    $('#save_category_attributes').click(function() {
        let modalForm = document.forms.category_attributes;
        for (let formController of modalForm.elements) {
            if (formController.required && !formController.value) {
                let alert = document.createElement('div');
                alert.className = 'alert alert-danger';
                alert.innerHTML = 'Please fill in the required form fields at the beginning of the form';
                document.querySelectorAll('#save_category_attributes')[0].before(alert);
                return;
            }

            if (formController.value && formController.value !== "Open this select menu") {
                pickedAttributes.push({
                    id: formController.id,
                    value: formController.value,
                });
                console.log('pickedAttributes:', pickedAttributes);
            }
        }

        productAttributesForm = document.forms[1];
        productAttributesForm.allCategoryAttributes.value = JSON.stringify(pickedAttributes);
        $('#categoryAttributesModal').modal('hide');
        let alertSuccess = document.createElement('div');
        alertSuccess.className = 'alert alert-success mt-2';
        alertSuccess.innerHTML = 'You have selected your product\'s attributes succesfully!';
        document.querySelectorAll('.category .input-wrapper')[document.querySelectorAll('.category .input-wrapper').length - 1].after(alertSuccess);
        setTimeout(() => alertSuccess.remove(), 3500);
    });
});


