<?php namespace Visiosoft\HepsiburadaModule\Integratedproduct\Listener;

use Visiosoft\AdvsModule\Adv\Event\DeletedAd;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\HepsiburadaModule\Integratedproduct\IntegratedproductRepository;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController;
use Visiosoft\HepsiburadaModule\Integratedproduct\Listener\UpdateProduct;
use Anomaly\Streams\Platform\Message\MessageBag;

class DeleteProduct extends UpdateProduct
{
    public function handleDelete(DeletedAd $deletedAdvModel)
    {
        $deletedProduct = $deletedAdvModel->getAdDetail();

        $integratedProducts = app(IntegratedproductRepository::class);

        // Detect whether the deleted product is an integrated product.

        if ($integratedProductToBeUpdated = $integratedProducts->findBy('product_id', $deletedProduct->id)) {
            // Yes! Let's delete the product on Hepsiburada as well.

            $apiRequestController = new ApiRequestController();
            $result = $apiRequestController->deleteListing(
                $apiRequestController->hepsiburada->merchantId, $integratedProductToBeUpdated->hepsiburada_sku, 
                json_decode($integratedProductToBeUpdated->hepsiburada_product_information)->merchantSku);

            $this->messages->success(trans('visiosoft.module.hepsiburada::message.deleted_successfully'));
        }
    }
}

