<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin\Helper;

Class Request
{

    public $apiTestMode = false;

    public $apiUrl;

    protected $merchantId;

    protected $apiUsername;

    protected $apiPassword;

    protected $method;

    public function __construct($merchantId, $username, $password, $testmode, $method = 'GET')
    {
        $this->setApiTestMode($testmode);
        $this->setApiMerchantId($merchantId);
        $this->setApiUsername($username);
        $this->setApiPassword($password);
        $this->setMethod($method);
    }

    public function setApiTestMode($is_test_mode = false)
    {
        $this->apiTestMode = $is_test_mode;
    }

    public function setApiMerchantId($merchantId)
    {
        $this->merchantId = $merchantId;
    }

    public function setApiUsername($username)
    {
        $this->apiUsername = $username;
    }

    public function setApiPassword($password)
    {
        $this->apiPassword = $password;
    }

    public function setApiUrl($apiUrl)
    {
        if ($this->apiTestMode) {
            $token = strtok($apiUrl, ".");
            $testModeUrl = str_replace($token, $token . "-sit", $apiUrl);
            $this->apiUrl = $testModeUrl;
        } else {
            $this->apiUrl = $apiUrl;
        }        
    }

    public function setMethod($method)
    {
        $this->method = strtoupper($method);
    }

    protected function authorization()
    {
        return base64_encode($this->apiUsername . ':' . $this->apiPassword);
    }

    public function getResponse($data = false, $authorization = true, $willFilePosted = false)
    {
        $ch = curl_init();
        $header = [];
        curl_setopt($ch, CURLOPT_URL, $this->apiUrl);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, $this->method);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLINFO_HEADER_OUT, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 20);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

        if ($authorization) {
            $header[] = 'Authorization: Basic ' . $this->authorization();
        }

        if ($this->method == 'POST') {
            if ($willFilePosted) {
                $pathOfFile = __DIR__.'/productinformation.json';

                // create the file and put the json data in it. 
                file_put_contents($pathOfFile, json_encode($data));
                $curlFile = curl_file_create($pathOfFile);

                $header[] = 'Content-Type:multipart/form-data';

                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, array(
                    'file' => $curlFile,
                ));
                
                // clear file content for the next request.
                file_put_contents($pathOfFile, "");
            } else {
                $header[] = 'Content-Type: application/json';
                curl_setopt($ch, CURLOPT_POST, 1);
                curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
            }
        }

        curl_setopt($ch, CURLOPT_HTTPHEADER, $header);
        $response = trim(curl_exec($ch));
        
        if (empty($response)) {
            throw new \Exception(trans('visiosoft.module.hepsiburada::message.empty_response'));
        }

        $response = json_decode($response);
        curl_close($ch);
        return $response;
    }

}