<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin\Helper;

use Visiosoft\HepsiburadaModule\Http\Controller\Admin\Services;

Class GateWay
{

	public $merchantId;

	public $apiUsername;

	public $apiPassword;

    public $apiTestMode;

	protected $allowedServices = array( 
		'listing' => 'ListingService',
		'product'  => 'ProductService',
		'order'    => 'OrderService',
	);

    public function __get($name)
    {
		if (!isset($this->allowedServices[$name])) {
			throw new \Exception(trans('visiosoft.module.hepsiburada::message.invalid_service_name'));
		}

		if (isset($this->$name)) {
			return $this->$name;
		}

		$this->$name = $this->createServiceInstance($this->allowedServices[$name]);
		return $this->$name;
    }

    protected function createServiceInstance($serviceName)
    {
    	$serviceName = "Visiosoft\HepsiburadaModule\Http\Controller\Admin\Services\\" .   $serviceName;
    	if (!class_exists($serviceName)) {
			throw new \Exception(trans('visiosoft.module.hepsiburada::message.invalid_service_name'));
    	}

		return new $serviceName($this->merchantId, $this->apiUsername, $this->apiPassword, $this->apiTestMode);
    }
    
}