<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController;
use Carbon\Carbon;
use Visiosoft\HepsiburadaModule\Order\OrderRepository;

class ApiRequestHelper extends AdminController
{
    protected $apiRequestHelper;

    public function __construct()
    {
        $this->apiRequestHelper = new ApiRequestController();
    }  

    public function fetchPreMatchedProducts()
    {
        $preMatchedProducts = $this->apiRequestHelper->fetchProductInformationBasedOnStatus(
            0, 100, 1, setting_value('visiosoft.module.hepsiburada::merchant_id'), "PRE_MATCHED", false);

        return view('visiosoft.module.hepsiburada::admin/integration/pre-matched-products', compact('preMatchedProducts'));
    }

    public function showStatusReport($trackingId, $page, $size, $version)
    {
        $statusReport = $this->apiRequestHelper->queryProductStatus($trackingId, $page, $size, $version);
        $statusDataArr = array_reverse( $statusReport->data );

        return view('visiosoft.module.hepsiburada::admin/integration/status-report', compact('statusDataArr'));
    }

    public function pullOrders()
    {
        // Fetches all orders that placed in the last half an hour.
        $now = Carbon::now();
        $halfAnHourAgo = Carbon::now()->subMinute(30);

        $response = $this->apiRequestHelper->getPaidOrders($this->apiRequestHelper->hepsiburada->merchantId, 
        $halfAnHourAgo->format('yyyy-MM-dd HH:mm'), $now->format('yyyy-MM-dd HH:mm'));

        if ($response->totalCount > 0) {
            $savedOrders = app(OrderRepository::class);
            $integratedProducts = app(IntegratedproductRepository::class);

            foreach ($response->items as $order) {
                if ( $integratedProduct = $integratedProducts->findBy('hepsiburada_sku', $order->sku) ) {                    
                    $savedOrder = $savedOrders->create([
                        'orderNumber' => $order->orderNumber,
                        'quantity' => $order->quantity,
                        'price' => $order->totalPrice->amount,
                        'product_id' => $integratedProduct['product_id'],                            
                    ]);
                } else {
                    return;
                }
            }
        }
    }
}