<?php namespace Visiosoft\HepsiburadaModule\Integratedproduct\Form;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Anomaly\Streams\Platform\Message\MessageBag;
use Visiosoft\HepsiburadaModule\Http\Controller\Admin\ApiRequestController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;

class ApplyForSalingProductFormHandler extends AdminController
{
    public function handle(ApplyForSalingProductFormBuilder $builder, MessageBag $messages)
    {    
        $advs = app(AdvRepositoryInterface::class);
        $advToBeIntegrated = $advs->find($builder->getFormEntry());        
        
        $productInformation = [
            [
                "merchant" => $builder->getFormValue('merchant_id'),
                "merchantSku" => $builder->getFormValue('merchant_sku'),
                "productName" => $builder->getFormValue('product_name'),
                "barcode" => $builder->getFormValue('barcode'),               
            ]
        ];

        $apiRequestController = new ApiRequestController();

        // we will upload the product

        $trackingId = $apiRequestController->fastListProduct($productInformation);
        $this->saveIntegration($advToBeIntegrated, $productInformation, $trackingId);
        $messages->success(trans('visiosoft.module.hepsiburada::message.success_integration'));            
    }

    public function saveIntegration($advToBeIntegrated, $productInformation, $trackingId)
    {
        $integratedProducts = app(IntegratedproductRepository::class);

        $integratedProduct = $integratedProducts->create([
            'product_id' => $advToBeIntegrated->id,
            'hepsiburada_sku' => null,
            'tracking_id' => $trackingId,
            'hepsiburada_product_information' => json_encode([
                "merchantSku" => $productInformation[0]->merchantSku,
                "productName" => $productInformation[0]->productName,
                "barcode" => $productInformation[0]->barcode,                 
            ]),
        ]);        
    }    
}
