<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin\Services;

use Visiosoft\HepsiburadaModule\Http\Controller\Admin\Helper\Request;

Class ProductService extends Request
{
	// Base API Url Adress

	public $apiUrl;

	// Making the necessary settings for the Request class

	public function __construct($merchantId, $username, $password, $testmode)
	{
		$this->apiUrl = setting_value('visiosoft.module.hepsiburada::product_service_url');
		parent::__construct($merchantId, $username, $password, $testmode);
	}


	// Fetches Hepsiburada categories.

    public function getCategories($leaf, $status, $available, $page, $size, $version)
    {
        $this->setApiUrl($this->apiUrl . 'categories/' . 'get-all-categories?' . 'leaf=' . $leaf . '&status=' . $status .
        '&available=' . $available . '&page=' . $page . '&size=' . $size . '&version=' . $version);

        return $this->getResponse();
    }

	// Quickly uploads the products registered in the HB catalog and having a global barcode to the store.

	public function fastListProduct($productInformation)
	{
		$this->setApiUrl($this->apiUrl . 'products/fastlisting');

		$this->setMethod("POST");

		return $this->getResponse($productInformation);
	}

	public function importProduct($productInformation, $authorization, $willFilePosted)
	{
		$this->setApiUrl($this->apiUrl . 'products/import');

		$this->setMethod("POST");

		return $this->getResponse($productInformation, $authorization, $willFilePosted);
	}

	// Fetches status-based product information of products belonging to a merchant.

	public function fetchProductInformationBasedOnStatus($page, $size, $version, $merchantId, $productStatus, $taskStatus)
    {
        $this->setApiUrl($this->apiUrl . 'products/products-by-merchant-and-status?' . 'page=' . $page . '&size=' . $size . 
		'&version=' . $version . '&merchantId=' . $merchantId . '&productStatus=' . $productStatus . '&taskStatus=' . $taskStatus);

		return $this->getResponse();
    }

	public function queryProductStatus($trackingId, $page, $size, $version)
    {
        $this->setApiUrl($this->apiUrl . 'products/status/' . $trackingId . '?page=' . $page . '&size=' . $size . '&version=' . $version);		

		return $this->getResponse();
    }

	// Fetches property information for categories that do not have subcategories.

	public function getCategoryAttributes($categoryId)
	{
		$this->setApiUrl($this->apiUrl . 'categories/' . $categoryId . '/attributes');

		return $this->getResponse();
	}

	// Fetches predefined values for attributes with category attribute type 'enum'.

	public function getAttributeValues($categoryId, $attributeId, $page, $size, $version)
	{
		$this->setApiUrl($this->apiUrl . 'categories/' . $categoryId . '/attribute/' . $attributeId . 
		'/values?' . 'page=' . $page . '&size=' . $size . '&version=' . $version);

		return $this->getResponse();
	}
}