<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin\Services;

use Visiosoft\HepsiburadaModule\Http\Controller\Admin\Helper\Request;

Class OrderService extends ListingService
{
	// Base API Url Adress

    public $apiUrl;

	// Making the necessary settings for the Request class

	public function __construct($merchantId, $username, $password, $testmode)
	{
        $this->apiUrl = setting_value('visiosoft.module.hepsiburada::order_service_url');
        Request::__construct($merchantId, $username, $password, $testmode);
    }

    // Listing paid orders
    public function getPaidOrders($merchantId, $offset, $limit, $beginDate, $endDate)
    {
        $query = ['offset' => $offset, 'limit' => $limit, 'beginDate' => $beginDate, 'endDate' => $endDate];
        $this->setApiUrl($this->apiUrl . $merchantId . '?' . http_build_query($query));

        return $this->getResponse();
    }

    public function createTestOrder($orderInformation, $authorization, $willFilePosted)
    {
        $this->setApiUrl($this->apiUrl . 'products/import');

        $this->setMethod("POST");

        return $this->getResponse($orderInformation, $authorization, $willFilePosted);
    }

}