<?php namespace Visiosoft\HepsiburadaModule\Http\Controller\Admin;

use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Carbon\Carbon;
use Visiosoft\HepsiburadaModule\Integratedproduct\IntegratedproductRepository;
use Visiosoft\HepsiburadaModule\Order\OrderRepository;

class ApiRequestHelper extends AdminController
{
    protected $apiRequestHelper;

    public function __construct()
    {
        $this->apiRequestHelper = new ApiRequestController();
    }  

    public function fetchPreMatchedProducts()
    {
        $preMatchedProducts = $this->apiRequestHelper->fetchProductInformationBasedOnStatus(
            0, 100, 1, setting_value('visiosoft.module.hepsiburada::merchant_id'), "PRE_MATCHED", false);
        return redirect('/admin/hepsiburada');
    }

    public function showStatusReport($trackingId, $page, $size, $version)
    {
        $statusReport = $this->apiRequestHelper->queryProductStatus($trackingId, $page, $size, $version);
        $statusDataArr = array_reverse( $statusReport->data );

        return view('visiosoft.module.hepsiburada::admin/integration/status-report', compact('statusDataArr'));
    }

    public function pullOrders()
    {
        // Fetches all orders that placed in the last half an hour.
        $now = Carbon::now();
        $halfAnHourAgo = Carbon::now()->subMinute(30);

        $response = $this->apiRequestHelper->getPaidOrders($this->apiRequestHelper->hepsiburada->merchantId, 0, 100,
            $halfAnHourAgo->format('Y-m-d H:i'), $now->format('Y-m-d H:i'));

        if ($response->totalCount > 0) {
            $savedOrders = app(OrderRepository::class);
            $integratedProducts = app(IntegratedproductRepository::class);

            foreach ($response->items as $order) {
                $integratedProduct = $integratedProducts->newQuery()
                    ->where('hepsiburada_product_information', 'LIKE', '%' . $order->sku . '%')
                    ->first();

                $duplicateControl = $savedOrders->newQuery()->where('order_number', $order->orderNumber)->first();

                if ($integratedProduct and !$duplicateControl) {
                    $savedOrder = $savedOrders->create([
                        'order_number' => $order->orderNumber,
                        'quantity' => $order->quantity,
                        'price' => $order->totalPrice->amount,
                        'product_id' => $integratedProduct['product_id'],
                    ]);
                } else {
                    return;
                }
            }
        }
    }
}