$(document).ready(function(){
    let categoryInputField = $("#category");
    let matchedCategoriesContainer = $(`<div class="list-group matched-categories" id="matched_categories"></div>`);
    let categoryAttributesRow = document.getElementById('category_attributes_row');

    getAllCategories();

    $("body").on("click", "a.cat-name", handleCategorySelect);

    function getAllCategories() {
        let url = `/admin/hepsiburada/get-categories/${true}/ACTIVE/${true}/0/2000/1`;
        $.ajax({
            url: url,
            dataType: "json",
            success: function(resultObject) {
                console.log(resultObject);
                if (resultObject.success) {
                    let categoryList = resultObject.data;
                    reStructureForm(categoryList);
                }
            }
        });        
    }

    function reStructureForm(categoryList) {
        categoryInputField.after(matchedCategoriesContainer);             
        listCategories(categoryList);
    }

    function listCategories(categoryList) {    
        categoryInputField.keyup(function() {
            if (categoryInputField.val().length < 2) {
                matchedCategoriesContainer.html(""); 
                matchedCategoriesContainer.hide();
                return;
            }            
            matchedCategoriesContainer.show();
            let currentInput = categoryInputField.val();
            var options = {
                pre: '<', 
                post: '>', 
                extract: function(el) { return el.name; }
            };
    
            let results = fuzzy.filter(currentInput, categoryList, options);
            let matches = results.map(function(el) { return el.original; });
    
            extraFilteredMatches = matches.filter(function(item, index, array) {            
                $result = item.name.toLowerCase().indexOf(`${categoryInputField.val().toLowerCase()}`);
                if ($result !== 0) {
                    return false;
                } else {
                    return true;
                }
            });
    
            matchedCategoriesContainer.html("");    
            extraFilteredMatches.forEach(function(matchedCategory, index, array) {
                matchedCategoriesContainer.append(`
                    <a href="#" id="${matchedCategory.categoryId}" 
                    class="list-group-item list-group-item-action category-option cat-name">${matchedCategory.name}</a>
                `);
            });
        });
    
        categoryInputField.blur(function(event) {
            if (!($(event.relatedTarget).attr('class') == "list-group-item list-group-item-action category-option cat-name")) {
                matchedCategoriesContainer.html(""); 
                matchedCategoriesContainer.hide();
            }
        });       
    }

    function handleCategorySelect(event) {
        event.preventDefault();
        categoryInputField.val($(this).attr('id') + ' - ' + $(this).text());
        matchedCategoriesContainer.html("");
        matchedCategoriesContainer.hide();
        getCategoryAttributes($(this).attr('id'));
    }

    function getCategoryAttributes(categoryId) {
        $.ajax({
            url: `/admin/hepsiburada/get-category-attributes/${categoryId}`,
            dataType: "json",
            success: function(resultObject) {
                console.log(resultObject);
                if (resultObject.success) {
                    showAttributeModalForm();
                    handleAttributes(resultObject.data.baseAttributes, categoryId, 'base-attribute');
                    handleAttributes(resultObject.data.attributes, categoryId, 'category-attribute');
                    handleAttributes(resultObject.data.variantAttributes, categoryId, 'variant-attribute');
                }
            }
        });
    }
    
    function showAttributeModalForm() {
        $('#categoryAttributesModal').modal('show');
    }

    function handleAttributes(attributes, categoryId, attributeType) {
        attributes.sort(compareNecessityStatus);
        console.log(attributes);
        attributes.forEach(function(attribute) {
            if (attribute.type === 'enum') {
                getAttributeValues(attribute, categoryId, attributeType);
            } else {
                populateAttributeModalForm(attribute, attributeType);
            }
        });
    }

    function getAttributeValues(attribute, categoryId, attributeType) {
        $.ajax({
            url: `/admin/hepsiburada/get-attribute-values/${categoryId}/${attribute.id}/0/1000/4`,
            dataType: "json",
            success: function(resultObject) {
                if (resultObject.success) {
                    populateAttributeModalForm(attribute, attributeType, resultObject.data);
                }
            }
        });        
    }

    function populateAttributeModalForm(attribute, attributeType, attributeValues = false) {
        // Detect if this attribute information was set when the product was uploaded to the OpenClassify website.  

        let wasAlreadySetAttributes = ['Ürün Adı', 'Ürün Açıklaması', 'Fiyat', 'Stok', 'Görsel1', 
        'Görsel2', 'Görsel3', 'Görsel4', 'Görsel5', 'Varyant Grup Id'];
        let wasAlreadySet = wasAlreadySetAttributes.includes(attribute.name);

        if (attributeValues && attributeValues.length > 0) {
            let options = '';
            for (let option of attributeValues) {
                options += `
                <option value="${option.value}">${option.value}</option>
                `;                        
            }
            categoryAttributesRow.innerHTML += `
            <div class="col-6 p-1 text-center">
                <label for="cars"><b>${attribute.name}</b><span class="require-symbol">
                    ${attribute.mandatory ? ' *' : ''}</span>
                </label>
                <select class="form-control ${attributeType}" id="${attribute.id}" name="${attribute.name}" 
                ${attribute.mandatory ? 'required' : ''}>

                    <option selected ${attribute.mandatory ? 'disabled' : ''} value="">Open this select menu</option>`
                +

                    options

                +

                `</select>
            </div>`;                    
        } else {
            debugger;
            categoryAttributesRow.innerHTML += `
            <div class="col-6 p-1 text-center" ${wasAlreadySet ? 'style="display:none;"' : ''}>
                <label for="cars"><b>${attribute.name}</b><span class="require-symbol">${attribute.mandatory ? ' *' : ''}</span></label>
                <input name="${attribute.name}" type="text" class="form-control ${attributeType}" 
                id="${attribute.id}" placeholder="Custom Value" ${attribute.mandatory && !wasAlreadySet ? 'required' : ''}>
            </div>
            `;            
        }
    }

    function compareNecessityStatus(attribute, nextAttribute) {
        if (attribute.mandatory > nextAttribute.mandatory) return -1;
        if (attribute.mandatory == nextAttribute.mandatory) return 0;
        if (attribute.mandatory < nextAttribute.mandatory) return 1;        
    }

});


