<?php

return [
    'merchant_id' => [
        'type'     => 'anomaly.field_type.text',
        'bind' => 'hepsiburada.merchant_id',
        'required' => true,
    ],     
    'api_username' => [
        'type'     => 'anomaly.field_type.text',
        'bind' => 'hepsiburada.api_username',
        'required' => true,        
    ],
    'api_password' => [
        'type'     => 'anomaly.field_type.text',
        'bind' => 'hepsiburada.api_password',
        'required' => true,        
    ],
    'test_environment' => [
        'type' => 'anomaly.field_type.boolean',
        'bind' => 'hepsiburada.test_environment',
    ],
    'order_service_url' => [
        'type' => 'anomaly.field_type.text',
        'bind' => 'hepsiburada.service_url',
        'required' => true,
        'config' => [
            'default_value' => 'https://oms-external.hepsiburada.com/orders/merchantid/'
        ]
    ],
    'listing_service_url' => [
        'type' => 'anomaly.field_type.text',
        'bind' => 'hepsiburada.service_url',
        'required' => true,
        'config' => [
            'default_value' => 'https://listing-external.hepsiburada.com/listings/merchantid/'
        ]
    ],
    'product_service_url' => [
        'type' => 'anomaly.field_type.text',
        'bind' => 'hepsiburada.service_url',
        'required' => true,
        'config' => [
            'default_value' => 'https://mpop.hepsiburada.com/product/api/'
        ]
    ],
];
