let slideIndex = 0;
autoSlides();
let autoSlidesTimeout = setTimeout(autoSlides, 5000);

// Next/previous controls
function plusSlides(n) {
    showSlides(slideIndex += n);
}

// Thumbnail image controls
function currentSlide(n) {
    showSlides(slideIndex = n);
}

function showSlides(n) {
    const slides = $(".my-slides");

    if (n > slides.length) {
        slideIndex = 1
    }
    if (n < 1) {
        slideIndex = slides.length
    }
    slides.hide();
    $(slides[slideIndex - 1]).show();
    $(".gg-slider-thumbnail, .mobile-slider-bullet-item").removeClass('selected');
    $(`.gg-slider-thumbnail:nth-child(${slideIndex}), .mobile-slider-bullet-item:nth-child(${slideIndex})`)
        .addClass('selected');
}

function autoSlides() {
    slideIndex++;
    showSlides(slideIndex);
}

$('.gg-slider-thumbnail, .mobile-slider-bullet-item').mouseover(function () {
    $(this).addClass('selected').siblings().removeClass('selected');
    slideIndex = $(this).index() + 1;
    showSlides(slideIndex);
})

$('input[name=keyword]').focus(function () {
    $('.header-search-container').addClass('focused')
    $('.search-overlay').show()
})

$('.search-overlay').click(function () {
    $('.header-search-container').removeClass('focused')
    $(this).hide()
})

$('.horizontal-menu-item').hover(function () {
    $('.horizontal-menu-mask').toggle()
})

$('.header-search-container button').hover(function () {
    $('input[name=keyword]').toggleClass('hovered')
})

$(document).ready(function(){
    var dailyDealSwiper = new Swiper('.daily-deal-slider', {
        slidesPerView: 1.2,
        slidesPerGroup: 1,
        spaceBetween: 20,
        navigation: {
            nextEl: '.daily-deal-slider .gg-slider-button-next',
            prevEl: '.daily-deal-slider .gg-slider-button-prev',
        },
        breakpoints: {
            576: {
                slidesPerView: 2.2,
                slidesPerGroup: 2,
            },
            768: {
                slidesPerView: 3.2,
                slidesPerGroup: 3,
            },
            992: {
                slidesPerView: 4.2,
                slidesPerGroup: 4,
            },
            1200: {
                slidesPerView: 5.2,
                slidesPerGroup: 5,
            },
        }
    });

    var yourChoicesSwiper = new Swiper('.your-choices-tab', {
        slidesPerView: 1.2,
        slidesPerGroup: 1,
        spaceBetween: 20,
        observer: true,
        observeParents: true,
        navigation: {
            nextEl: '.your-choices-tab .gg-slider-button-next',
            prevEl: '.your-choices-tab .gg-slider-button-prev',
        },
        breakpoints: {
            576: {
                slidesPerView: 2.2,
                slidesPerGroup: 2,
            },
            768: {
                slidesPerView: 3.2,
                slidesPerGroup: 3,
            },
            1200: {
                slidesPerView: 4.2,
                slidesPerGroup: 4,
            },
        }
    });

    var whatYouLookingSwiper = new Swiper('.what-you-looking-slider', {
        slidesPerView: 1,
        slidesPerGroup: 1,
        spaceBetween: 20,
        breakpoints: {
            768: {
                slidesPerView: 2,
                slidesPerGroup: 2,
            },
            992: {
                slidesPerView: 3,
                slidesPerGroup: 3,
            },
        }
    });
});