<?php namespace Visiosoft\GgTheme\SettingHandler;

use Anomaly\CheckboxesFieldType\CheckboxesFieldType;
use Visiosoft\AdvsModule\Adv\AdvRepository;

class AdvsOptions
{
    private $advsRepository;

    public function __construct(AdvRepository $advsRepository)
    {
        $this->advsRepository = $advsRepository;
    }

    public function handle(CheckboxesFieldType $fieldType)
    {
        $advs = $this->advsRepository->newQuery()->get();
        $options = array();
        foreach ($advs as $adv) {
            $options[$adv->id] = $adv->name;
        }
        $fieldType->setOptions($options);
    }

}