<?php namespace Visiosoft\GgTheme;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;


class GgThemeSeeder extends Seeder
{
    protected $customFieldsRepository;

    public function __construct(CustomFieldRepositoryInterface $customFieldsRepository)
    {
        $this->customFieldsRepository = $customFieldsRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields') && empty($this->customFieldsRepository->findBySlug('delivery_time'))) {
            $this->customFieldsRepository->create([
                'en' => [
                    'name' => 'Delivery Time',
                ],
                'tr' => [
                    'name' => 'Teslimat Süresi',
                ],
                'slug' => 'delivery_time',
                'type' => 'integer',
                'show_filter' => 1
            ]);
        }
    }
}
