<?php namespace Visiosoft\FranchModule;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\FranchModule\Sector\Form\Handler\SectorField;
use Visiosoft\FranchModule\Sector\SectorModel;
use Visiosoft\LocationModule\City\CityModel;

class FranchModuleSeeder extends Seeder
{
    public function run(
        StreamRepositoryInterface $streamRepository,
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository
    )
    {
        $namespace = 'store';
        $stream = $streamRepository->findBySlugAndNamespace('store', $namespace);

        $activeCurrencies = setting_value('visiosoft.module.advs::enabled_currencies');
        $currencies = '';
        foreach ($activeCurrencies as $currency) {
            $currencies .= "$currency:$currency\n";
        }


        $customFields = [
            [
                'name' => 'Sector',
                'slug' => 'sector',
                'type' => 'anomaly.field_type.relationship',
                "config" => [
                    "related" => SectorModel::class,
                    "mode" => "dropdown",
                    "handler" => SectorField::class
                ]
            ],
            [
                'name' => 'Sub Sector',
                'slug' => 'sub_sector',
                'type' => 'anomaly.field_type.multiple',
                "config" => [
                    "related" => SectorModel::class,
                    "mode" => "lookup",
                ]
            ],
            [
                'name' => 'Establishment Date',
                'slug' => 'establishment_date',
                'type' => 'anomaly.field_type.datetime',
                "config" => [
                    "mode" => "date",
                ]
            ],
            [
                'name' => 'Number of Branches',
                'slug' => 'number_of_branches',
                'type' => 'anomaly.field_type.integer',
                "config" => [
                    "separator" => ".",
                    "min"       => 0,
                ]
            ],
            [
                'name' => 'Target Regions',
                'slug' => 'target_regions',
                'type' => 'anomaly.field_type.multiple',
                "config" => [
                    "related" => CityModel::class,
                    "mode" => "lookup",
                ]
            ],
            [
                'name' => 'Minimum m2 Requirements',
                'slug' => 'minimum_m2_requirements',
                'type' => 'anomaly.field_type.integer',
                "config" => [
                    "separator" => ".",
                    "min"       => 0,
                ]
            ],
            [
                'name' => 'Franchise Fee',
                'slug' => 'franchise_fee',
                'type' => 'anomaly.field_type.decimal',
                "config" => [
                    "separator" => ".",
                    "point"     => ",",
                    "decimals"  => 2,
                    "min"       => 0,
                ]
            ],
            [
                'name' => 'Franchise Fee Currency',
                'slug' => 'franchise_fee_currency',
                'type' => 'anomaly.field_type.select',
                "config" => [
                    "options" => $currencies,
                    "mode" => "dropdown",
                ]
            ],
            [
                'name' => 'CRO Share',
                'slug' => 'cro_share',
                'type' => 'anomaly.field_type.decimal',
                "config" => [
                    "separator" => ".",
                    "point"     => ",",
                    "decimals"  => 2,
                    "min"       => 0,
                ]
            ],
            [
                'name' => 'Total Investment Amount',
                'slug' => 'total_investment_amount',
                'type' => 'anomaly.field_type.decimal',
                "config" => [
                    "separator" => ".",
                    "point"     => ",",
                    "decimals"  => 2,
                    "min"       => 0,
                ]
            ],
            [
                'name' => 'Total Investment Amount Currency',
                'slug' => 'total_investment_amount_currency',
                'type' => 'anomaly.field_type.select',
                "config" => [
                    "options" => $currencies,
                    "mode" => "dropdown",
                ]
            ],
            [
                'name' => 'Education Support',
                'slug' => 'education_support',
                'type' => 'anomaly.field_type.boolean',
                "config" => [
                    "default_value" => false,
                    "mode"          => "radio",
                ]
            ],
        ];

        foreach ($customFields as $customField) {
            $field = $fieldRepository->findBySlugAndNamespace($customField['slug'], $namespace);

            if (!$field) {
                $data = [
                    'name' => $customField['name'],
                    'namespace' => $namespace,
                    'slug' => $customField['slug'],
                    'type' => $customField['type'],
                    'locked' => 0
                ];
                if (isset($customField['config'])) {
                    $data['config'] = $customField['config'];
                }

                $field = $fieldRepository->create($data);

                $assignmentRepository->create([
                    'stream_id' => $stream->id,
                    'field_id' => $field->id
                ]);
            }
        }
    }
}