<?php namespace Visiosoft\FranchModule\Franch\Form;


use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Anomaly\SelectFieldType\SelectFieldType;
use Anomaly\TagsFieldType\TagsFieldType;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;
use Visiosoft\LocationModule\City\Contract\CityRepositoryInterface;

class FranchisorBrandInfoFormFields
{
    public function handle(FranchisorBrandInfoFormBuilder $builder)
    {
        $builder->setFields([
            "logo" => [
                "label" => "visiosoft.module.franch::field.logo",
                "type" => "visiosoft.field_type.singlefile",
                "config" => [
                    "folders" => ['images'],
                    "mode" => "upload",
                ]
            ],
            "brand_name" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.brand_name",
                "type" => "anomaly.field_type.text",
            ],
            "sector" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.sector",
                "type"   => "anomaly.field_type.relationship",
                "config" => [
                    "handler" => function (RelationshipFieldType $fieldType, SectorRepositoryInterface $entries) {
                        $fieldType->setOptions(
                            $entries->newQuery()
                                ->whereNull('parent_id')
                                ->get()
                                ->pluck('name', 'id')
                                ->all()
                        );
                    }
                ]
            ],
            "sub_sector" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.sub_sector",
                "type"   => "anomaly.field_type.checkboxes",
                "config" => [
                    "options" => [],
                    "mode" => "checkboxes",
                ]
            ],
            "establishment_date" => [
                "label" => "visiosoft.module.franch::field.establishment_date",
                "type"   => "anomaly.field_type.datetime",
                "config" => [
                    "default_value" => "now",
                    "mode"          => "date",
                    "date_format"   => "j F, Y",
                    "picker"        => true,
                ]
            ],
            "authority_name" => [
                "label" => "visiosoft.module.franch::field.authority_name",
                "type" => "anomaly.field_type.text",
            ],
            "authority_email" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.authority_email",
                "type" => "anomaly.field_type.email",
            ],
            "authority_phone" => [
                "label" => "visiosoft.module.franch::field.authority_phone",
                "type" => "anomaly.field_type.text",
            ],
            "website_address" => [
                "label" => "visiosoft.module.franch::field.website_address",
                "type"   => "anomaly.field_type.url",
            ],
            "no_of_branches" => [
                "label" => "visiosoft.module.franch::field.no_of_branches",
                "type" => "anomaly.field_type.integer",
            ],
            "target_regions" => [
                "label" => "visiosoft.module.franch::field.target_regions",
                "type"   => "anomaly.field_type.tags",
                "config" => [
                    "handler" => function (TagsFieldType $fieldType, CityRepositoryInterface $entries) {
                        $regions = $entries->newQuery();

                        if ($defaultCountry = setting_value('visiosoft.module.location::default_country')) {
                            $regions = $regions->where('parent_country_id', $defaultCountry);
                        }

                        $fieldType->setOptions(
                            $regions
                                ->get()
                                ->pluck('name')
                                ->all()
                        );
                    },
                    "enforce_options" => true,
                ],
            ],
            "min_m2_requirements" => [
                "label" => "visiosoft.module.franch::field.min_m2_requirements",
                "type" => "anomaly.field_type.integer"
            ],
            "franchise_fee" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.franchise_fee",
                "type" => "anomaly.field_type.integer"
            ],
            "franchise_fee_currency" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.franchise_fee_currency",
                "type"   => "anomaly.field_type.select",
                "config" => [
                    "handler" => function (SelectFieldType $fieldType) {
                        $activeCurrencies = setting_value('visiosoft.module.advs::enabled_currencies');
                        $fieldType->setOptions(array_combine($activeCurrencies, $activeCurrencies));
                    },
                ]
            ],
            "cro_share" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.cro_share",
                "type" => "anomaly.field_type.integer"
            ],
            "total_investment_amount" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.total_investment_amount",
                "type" => "anomaly.field_type.integer"
            ],
            "total_investment_amount_currency" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.total_investment_amount_currency",
                "type"   => "anomaly.field_type.select",
                "config" => [
                    "handler" => function (SelectFieldType $fieldType) {
                        $activeCurrencies = setting_value('visiosoft.module.advs::enabled_currencies');
                        $fieldType->setOptions(array_combine($activeCurrencies, $activeCurrencies));
                    },
                ]
            ],
            "education_support" => [
                "label" => "visiosoft.module.franch::field.education_support",
                "type"   => "anomaly.field_type.boolean",
                "config" => [
                    "mode"          => "radio",
                ]
            ],
            "kvk" => [
                "required" => true,
                "type"   => "anomaly.field_type.boolean",
                "config" => [
                    "default_value" => false,
                    "mode"          => "checkbox",
                    "label"         => "visiosoft.module.franch::field.kvk_label",
                ]
            ],
        ]);
    }
}
