<?php namespace Visiosoft\FranchModule\Notifications;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;


class FranchModuleNotificationsTemplateSeeder extends Seeder
{
    use DispatchesJobs;
    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {

            $templates = [
                [
                    'en' => [
                        'message' => '<p>Company Name: {company_name}
                                    </p>
                                    <p>Sector: {sector}
                                    </p>
                                    <p>Service Details: {service_details}</p>
                                    <p>Contact Email: {contact_email}
                                    </p>
                                    <p>Contact Phone: {contact_phone}
                                    </p>
                                    <p>Website Address: {website_address}</p>',
                        'name' => 'Solution Partner Information Form',
                        'greeting' => 'Hello',
                        'subject' => 'Solution Partner Information Form'
                    ],
                    'slug' => 'solution_partner_information_form',
                    'stream' => 'franch'
                ],
                [
                    'en' => [
                        'message' => '<p>Brand Name: {brand_name}</p>
                                    <p>Sector: {sector}
                                    </p>
                                    <p>Sub Sector: {sub_sector}
                                    </p>
                                    <p>Establishment Date: {establishment_date}
                                    </p>
                                    <p>Authority First Name / Last Name: {authority_name}
                                    </p>
                                    <p>Authority Email: {authority_email}
                                    </p>
                                    <p>Authority Phone: {authority_phone}
                                    </p>
                                    <p>Website Address: {website_address}
                                    </p>
                                    <p>Number of Branches: {no_of_branches}
                                    </p>
                                    <p>Target Regions: {target_regions}
                                    </p>
                                    <p>Minimum m2 Requirements: {min_m2_requirements}
                                    </p>
                                    <p>Franchise Fee: {franchise_fee}
                                    </p>
                                    <p>Franchise Fee Currency: {franchise_fee_currency}
                                    </p>
                                    <p>CRO Share: {cro_share}
                                    </p>
                                    <p>Total Investment Amount: {total_investment_amount}
                                    </p>
                                    <p>Total Investment Amount Currency: {total_investment_amount_currency}
                                    </p>
                                    <p>Education Support: {education_support}</p>',
                        'name' => 'Franchisor Brand Information Form',
                        'greeting' => 'Hello',
                        'subject' => 'Franchisor Brand Information Form'
                    ],
                    'slug' => 'franchisor_brand_information_form',
                    'stream' => 'franch'
                ]
            ];

            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }
        }
    }
}