<?php namespace Visiosoft\FranchModule\Franch\Form;

use Visiosoft\FranchModule\Events\SolutionPartnerInfoSent;

class SolutionPartnerInfoFormHandler
{
    protected $messages;

    public function __construct()
    {
        $this->messages = app('Anomaly\Streams\Platform\Message\MessageBag');
    }

    public function handle(SolutionPartnerInfoFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        event(new SolutionPartnerInfoSent($builder->getFormValues()));

        $this->messages->success(trans('visiosoft.module.franch::message.form_sent_successfully'));
    }
}
