<?php namespace Visiosoft\FranchModule\Franch\Form;

use Visiosoft\FranchModule\Events\FranchisorBrandInfoSent;

class FranchisorBrandInfoFormHandler
{
    protected $messages;

    public function __construct()
    {
        $this->messages = app('Anomaly\Streams\Platform\Message\MessageBag');
    }

    public function handle(FranchisorBrandInfoFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        event(new FranchisorBrandInfoSent($builder->getFormValues()));

        $this->messages->success(trans('visiosoft.module.franch::message.form_sent_successfully'));
    }
}
