<?php namespace Visiosoft\FranchModule\Franch\Form;

use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;

class SolutionPartnerInfoFormFields
{
    public function handle(SolutionPartnerInfoFormBuilder $builder)
    {
        $builder->setFields([
            "logo" => [
                "label" => "visiosoft.module.franch::field.logo",
                "type" => "visiosoft.field_type.singlefile",
                "config" => [
                    "folders" => ['images'],
                    "mode" => "upload",
                ]
            ],
            "company_name" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.company_name",
                "type" => "anomaly.field_type.text",
            ],
            "sector" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.sector",
                "type"   => "anomaly.field_type.relationship",
                "config" => [
                    "handler" => function (RelationshipFieldType $fieldType, SectorRepositoryInterface $entries) {
                        $fieldType->setOptions(
                            $entries->newQuery()
                                ->whereNull('parent_id')
                                ->get()
                                ->pluck('name', 'name')
                                ->all()
                        );
                    }
                ]
            ],
            "service_details" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.service_details",
                "type" => "anomaly.field_type.text",
            ],
            "contact_email" => [
                "required" => true,
                "label" => "visiosoft.module.franch::field.contact_email",
                "type" => "anomaly.field_type.email",
            ],
            "contact_phone" => [
                "label" => "visiosoft.module.franch::field.contact_phone",
                "type" => "anomaly.field_type.text",
            ],
            "website_address" => [
                "label" => "visiosoft.module.franch::field.website_address",
                "type"   => "anomaly.field_type.url",
            ],
            "kvk" => [
                "required" => true,
                "type"   => "anomaly.field_type.boolean",
                "config" => [
                    "default_value" => false,
                    "mode"          => "checkbox",
                    "label"         => "visiosoft.module.franch::field.kvk_label",
                ]
            ],
        ]);
    }
}
