<?php namespace Visiosoft\FranchModule\Sector\Form;


use Anomaly\RelationshipFieldType\RelationshipFieldType;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;

class SectorFormFields
{

    public function handle(SectorFormBuilder $builder)
    {
        $builder->setFields(
            [
                '*',
                'parent' => [
                    'handler' => function (RelationshipFieldType $fieldType, SectorRepositoryInterface $entries) {
                        $fieldType->setOptions(
                            $entries->newQuery()
                                ->whereNull('parent_id')
                                ->get()
                                ->pluck('name', 'id')
                                ->all()
                        );
                    },
                ],
            ]
        );
    }
}
