<?php namespace Visiosoft\FranchModule\Franch\Form;

use Visiosoft\FranchModule\Events\FranchisorBrandInfoSent;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;

class FranchisorBrandInfoFormHandler
{
    protected $messages;
    protected $sectorRepository;

    public function __construct(SectorRepositoryInterface $sectorRepository)
    {
        $this->messages = app('Anomaly\Streams\Platform\Message\MessageBag');
        $this->sectorRepository = $sectorRepository;
    }

    public function handle(FranchisorBrandInfoFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        $fields = $builder->getFormValues()->toArray();

        $fields['establishment_date'] = $fields['establishment_date']->toDateString();
        $fields['sub_sector'] = $fields['sub_sector'] ? implode(', ', $fields['sub_sector']) : "";
        $fields['target_regions'] = $fields['target_regions'] ? implode(', ', $fields['target_regions']) : "";
        $fields['sector'] = $this->sectorRepository->find($fields['sector'])->name;
        $fields['education_support'] = $fields['education_support'] ?
            trans('visiosoft.module.franch::field.yes') : trans('visiosoft.module.franch::field.no');

        event(new FranchisorBrandInfoSent($fields));

        $this->messages->success(trans('visiosoft.module.franch::message.form_sent_successfully'));
    }
}
