<?php namespace Visiosoft\FranchModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\FranchModule\Region\Contract\RegionRepositoryInterface;
use Visiosoft\FranchModule\Region\RegionRepository;
use Anomaly\Streams\Platform\Model\Franch\FranchRegionsEntryModel;
use Visiosoft\FranchModule\Region\RegionModel;
use Visiosoft\FranchModule\Sector\Contract\SectorRepositoryInterface;
use Visiosoft\FranchModule\Sector\SectorRepository;
use Anomaly\Streams\Platform\Model\Franch\FranchSectorEntryModel;
use Visiosoft\FranchModule\Sector\SectorModel;
use Illuminate\Routing\Router;
use Visiosoft\FranchModule\Franch\Form\FranchisorBrandInfoFormBuilder;

class FranchModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/franch/regions'           => 'Visiosoft\FranchModule\Http\Controller\Admin\RegionsController@index',
        'admin/franch/regions/create'    => 'Visiosoft\FranchModule\Http\Controller\Admin\RegionsController@create',
        'admin/franch/regions/edit/{id}' => 'Visiosoft\FranchModule\Http\Controller\Admin\RegionsController@edit',
        'admin/franch'           => 'Visiosoft\FranchModule\Http\Controller\Admin\SectorController@index',
        'admin/franch/create'    => 'Visiosoft\FranchModule\Http\Controller\Admin\SectorController@create',
        'admin/franch/edit/{id}' => 'Visiosoft\FranchModule\Http\Controller\Admin\SectorController@edit',
        'franchisor-brand-information-form' => [
            'as' => 'visiosoft.module.franch::franchisor_brand_information_form',
            'uses' => 'Visiosoft\FranchModule\Http\Controller\FranchController@brandForm',
        ],
        'solution-partner-information-form' => [
            'as' => 'visiosoft.module.franch::solution_partner_information_form',
            'uses' => 'Visiosoft\FranchModule\Http\Controller\FranchController@PartnerForm',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\FranchModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\FranchModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\FranchModule\Event\ExampleEvent::class => [
        //    Visiosoft\FranchModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\FranchModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        FranchRegionsEntryModel::class => RegionModel::class,
        FranchSectorEntryModel::class => SectorModel::class,
        'franchisor_brand_info' => FranchisorBrandInfoFormBuilder::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        RegionRepositoryInterface::class => RegionRepository::class,
        SectorRepositoryInterface::class => SectorRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
